/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.pojo.report;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class Text {
    private Color textColor;
    private PDFont font;
    private float fontSize;
    private float xoffset;
    private float yoffset;
    private String text;

    private static Color $default$textColor() {
        return Color.BLACK;
    }

    private static PDFont $default$font() {
        return PDType1Font.HELVETICA;
    }

    Text(Color textColor, PDFont font, float fontSize, float xoffset, float yoffset, String text) {
        this.textColor = textColor;
        this.font = font;
        this.fontSize = fontSize;
        this.xoffset = xoffset;
        this.yoffset = yoffset;
        this.text = text;
    }

    public static TextBuilder builder() {
        return new TextBuilder();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public PDFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public float getXoffset() {
        return this.xoffset;
    }

    public float getYoffset() {
        return this.yoffset;
    }

    public String getText() {
        return this.text;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setXoffset(float xoffset) {
        this.xoffset = xoffset;
    }

    public void setYoffset(float yoffset) {
        this.yoffset = yoffset;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text other = (Text)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Color this$textColor = this.getTextColor();
        Color other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !((Object)this$textColor).equals(other$textColor)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        if (Float.compare(this.getFontSize(), other.getFontSize()) != 0) {
            return false;
        }
        if (Float.compare(this.getXoffset(), other.getXoffset()) != 0) {
            return false;
        }
        if (Float.compare(this.getYoffset(), other.getYoffset()) != 0) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Text;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Color $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : ((Object)$textColor).hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getFontSize());
        result = result * 59 + Float.floatToIntBits(this.getXoffset());
        result = result * 59 + Float.floatToIntBits(this.getYoffset());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "Text(textColor=" + this.getTextColor() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", xoffset=" + this.getXoffset() + ", yoffset=" + this.getYoffset() + ", text=" + this.getText() + ")";
    }

    public static class TextBuilder {
        private Color textColor;
        private boolean textColor$set;
        private PDFont font;
        private boolean font$set;
        private float fontSize;
        private float xoffset;
        private float yoffset;
        private String text;

        TextBuilder() {
        }

        public TextBuilder textColor(Color textColor) {
            this.textColor = textColor;
            this.textColor$set = true;
            return this;
        }

        public TextBuilder font(PDFont font) {
            this.font = font;
            this.font$set = true;
            return this;
        }

        public TextBuilder fontSize(float fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public TextBuilder xoffset(float xoffset) {
            this.xoffset = xoffset;
            return this;
        }

        public TextBuilder yoffset(float yoffset) {
            this.yoffset = yoffset;
            return this;
        }

        public TextBuilder text(String text) {
            this.text = text;
            return this;
        }

        public Text build() {
            return new Text(this.textColor$set ? this.textColor : Text.$default$textColor(), this.font$set ? this.font : Text.$default$font(), this.fontSize, this.xoffset, this.yoffset, this.text);
        }

        public String toString() {
            return "Text.TextBuilder(textColor=" + this.textColor + ", font=" + this.font + ", fontSize=" + this.fontSize + ", xoffset=" + this.xoffset + ", yoffset=" + this.yoffset + ", text=" + this.text + ")";
        }
    }
}

