/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PageMode;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.bookmark.Bookmark;
import tech.grasshopper.pdf.chapter.Chapter;
import tech.grasshopper.pdf.chapter.detailed.DetailedChapter;
import tech.grasshopper.pdf.chapter.feature.FeatureChapter;
import tech.grasshopper.pdf.chapter.scenario.ScenarioChapter;
import tech.grasshopper.pdf.chapter.summary.SummaryChapter;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.font.ReportFont;

public class PDFCucumberReport {
    private static final Logger logger = Logger.getLogger(PDFCucumberReport.class.getName());
    private ReportData reportData;
    private File reportFile;
    private PDDocument document;
    private Destination.ChapterDestinationStore destinations;
    private ReportConfig reportConfig;
    private List<Chapter> chapters = new ArrayList<Chapter>();

    public PDFCucumberReport(ReportData reportData, String reportDirectory) {
        this(reportData, new File(String.valueOf(reportDirectory) + "/report.pdf"));
    }

    public PDFCucumberReport(ReportData reportData, File reportFile) {
        this.reportData = reportData;
        this.reportFile = reportFile;
        this.document = new PDDocument();
        this.destinations = new Destination.ChapterDestinationStore();
        ReportFont.loadReportFontFamily(this.document);
        this.createReportDirectory(this.reportFile.getParent());
        this.collectReportConfiguration();
        reportData.populateChapterData();
        this.collectChapters();
    }

    private void createReportDirectory(String reportDirectory) {
        File dir = new File(reportDirectory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private void collectReportConfiguration() {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(ReportConfig.class));
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream("src/test/resources/pdf-config.yaml");
            this.reportConfig = (ReportConfig)yaml.load((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.INFO, "PDF report configuration not found. Using default settings.");
            this.reportConfig = new ReportConfig();
        }
    }

    private void collectChapters() {
        this.chapters.add(((SummaryChapter.SummaryChapterBuilder)((SummaryChapter.SummaryChapterBuilder)((SummaryChapter.SummaryChapterBuilder)((SummaryChapter.SummaryChapterBuilder)SummaryChapter.builder().displayData(this.reportData.getSummaryData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build());
        if (this.reportConfig.isDisplayFeature()) {
            this.chapters.add(((FeatureChapter.FeatureChapterBuilder)((FeatureChapter.FeatureChapterBuilder)((FeatureChapter.FeatureChapterBuilder)((FeatureChapter.FeatureChapterBuilder)FeatureChapter.builder().displayData(this.reportData.getFeatureData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build());
        }
        if (this.reportConfig.isDisplayScenario()) {
            this.chapters.add(((ScenarioChapter.ScenarioChapterBuilder)((ScenarioChapter.ScenarioChapterBuilder)((ScenarioChapter.ScenarioChapterBuilder)((ScenarioChapter.ScenarioChapterBuilder)ScenarioChapter.builder().displayData(this.reportData.getScenarioData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build());
        }
        if (this.reportConfig.isDisplayDetailed()) {
            this.chapters.add(((DetailedChapter.DetailedChapterBuilder)((DetailedChapter.DetailedChapterBuilder)((DetailedChapter.DetailedChapterBuilder)((DetailedChapter.DetailedChapterBuilder)DetailedChapter.builder().displayData(this.reportData.getFeatureData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build());
        }
    }

    public void createReport() {
        this.chapters.forEach(c -> c.createChapter());
        Bookmark bookmark = Bookmark.builder().reportConfig(this.reportConfig).build();
        PDDocumentOutline outline = bookmark.createDocumentOutline(this.destinations, this.reportData);
        Annotation.updateDestination(this.reportData);
        this.document.getDocumentCatalog().setDocumentOutline(outline);
        this.document.getDocumentCatalog().setPageMode(PageMode.USE_OUTLINES);
        try {
            this.document.save(this.reportFile);
            this.document.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }
}

