/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.annotation;

import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;

public class Annotation {
    private String title;
    private int xBottom;
    private int yBottom;
    private int width;
    private int height;

    public PDAnnotationLink createPDAnnotationLink() {
        PDRectangle position = new PDRectangle((float)this.xBottom, (float)this.yBottom, (float)this.width, (float)this.height);
        PDAnnotationLink link = new PDAnnotationLink();
        PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
        borderULine.setStyle("U");
        borderULine.setWidth(1.0f);
        link.setBorderStyle(borderULine);
        link.setRectangle(position);
        return link;
    }

    public static void updateDestination(ReportData reportData) {
        for (Feature feature : reportData.getFeatures()) {
            feature.getAnnotations().forEach(a -> {
                PDActionGoTo action = new PDActionGoTo();
                action.setDestination((PDDestination)feature.getDestination());
                a.setAction((PDAction)action);
            });
            for (Scenario scenario : feature.getScenarios()) {
                scenario.getAnnotations().forEach(a -> {
                    PDActionGoTo action = new PDActionGoTo();
                    action.setDestination((PDDestination)scenario.getDestination());
                    a.setAction((PDAction)action);
                });
            }
        }
    }

    Annotation(String title, int xBottom, int yBottom, int width, int height) {
        this.title = title;
        this.xBottom = xBottom;
        this.yBottom = yBottom;
        this.width = width;
        this.height = height;
    }

    public static AnnotationBuilder builder() {
        return new AnnotationBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public int getXBottom() {
        return this.xBottom;
    }

    public int getYBottom() {
        return this.yBottom;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setXBottom(int xBottom) {
        this.xBottom = xBottom;
    }

    public void setYBottom(int yBottom) {
        this.yBottom = yBottom;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (this.getXBottom() != other.getXBottom()) {
            return false;
        }
        if (this.getYBottom() != other.getYBottom()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        return this.getHeight() == other.getHeight();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Annotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        result = result * 59 + this.getXBottom();
        result = result * 59 + this.getYBottom();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        return result;
    }

    public String toString() {
        return "Annotation(title=" + this.getTitle() + ", xBottom=" + this.getXBottom() + ", yBottom=" + this.getYBottom() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
    }

    public static class AnnotationBuilder {
        private String title;
        private int xBottom;
        private int yBottom;
        private int width;
        private int height;

        AnnotationBuilder() {
        }

        public AnnotationBuilder title(String title) {
            this.title = title;
            return this;
        }

        public AnnotationBuilder xBottom(int xBottom) {
            this.xBottom = xBottom;
            return this;
        }

        public AnnotationBuilder yBottom(int yBottom) {
            this.yBottom = yBottom;
            return this;
        }

        public AnnotationBuilder width(int width) {
            this.width = width;
            return this;
        }

        public AnnotationBuilder height(int height) {
            this.height = height;
            return this;
        }

        public Annotation build() {
            return new Annotation(this.title, this.xBottom, this.yBottom, this.width, this.height);
        }

        public String toString() {
            return "Annotation.AnnotationBuilder(title=" + this.title + ", xBottom=" + this.xBottom + ", yBottom=" + this.yBottom + ", width=" + this.width + ", height=" + this.height + ")";
        }
    }
}

