/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.chapter.detailed.StepOrHookComponent;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Row;

public class DataTableComponent
implements StepOrHookComponent {
    private List<Row> rows;
    private static final int LINE_HEIGHT = 15;
    private static final int MAX_ROWS = 4;
    private static final int MAX_COLS = 4;
    private static final PDFont FONT = ReportFont.REGULAR_FONT;
    private static final int FONT_SIZE = 8;
    private static final int WIDTH = 65;
    private final TextLengthOptimizer dataCellOptimizer;

    @Override
    public int componentHeight() {
        int height = 0;
        if (!this.rows.isEmpty()) {
            height = this.rows.size() <= 4 ? this.rows.size() * 15 : 60;
        }
        return height;
    }

    @Override
    public void componentText(ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder) {
        if (!this.rows.isEmpty()) {
            List<Row> dataTableRows = this.rows.size() <= 4 ? this.rows : this.rows.subList(0, 4);
            for (Row row : dataTableRows) {
                List<String> columns = row.getCells().size() <= 4 ? row.getCells() : row.getCells().subList(0, 4);
                String rowData = "    | ";
                for (String col : columns) {
                    rowData = String.valueOf(rowData) + this.dataCellOptimizer.optimizeDataCellText(col) + " | ";
                }
                paragraphBuilder.append(StyledText.builder().text(rowData).font(FONT).fontSize(Float.valueOf(8.0f)).build()).appendNewLine();
            }
        }
    }

    private static TextLengthOptimizer $default$dataCellOptimizer() {
        return TextLengthOptimizer.builder().font(FONT).fontsize(8).spaceWidth(65).build();
    }

    DataTableComponent(List<Row> rows, TextLengthOptimizer dataCellOptimizer) {
        this.rows = rows;
        this.dataCellOptimizer = dataCellOptimizer;
    }

    public static DataTableComponentBuilder builder() {
        return new DataTableComponentBuilder();
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public TextLengthOptimizer getDataCellOptimizer() {
        return this.dataCellOptimizer;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTableComponent)) {
            return false;
        }
        DataTableComponent other = (DataTableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Row> this$rows = this.getRows();
        List<Row> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        TextLengthOptimizer this$dataCellOptimizer = this.getDataCellOptimizer();
        TextLengthOptimizer other$dataCellOptimizer = other.getDataCellOptimizer();
        return !(this$dataCellOptimizer == null ? other$dataCellOptimizer != null : !((Object)this$dataCellOptimizer).equals(other$dataCellOptimizer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTableComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Row> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        TextLengthOptimizer $dataCellOptimizer = this.getDataCellOptimizer();
        result = result * 59 + ($dataCellOptimizer == null ? 43 : ((Object)$dataCellOptimizer).hashCode());
        return result;
    }

    public String toString() {
        return "DataTableComponent(rows=" + this.getRows() + ", dataCellOptimizer=" + this.getDataCellOptimizer() + ")";
    }

    public static class DataTableComponentBuilder {
        private List<Row> rows;
        private TextLengthOptimizer dataCellOptimizer;
        private boolean dataCellOptimizer$set;

        DataTableComponentBuilder() {
        }

        public DataTableComponentBuilder rows(List<Row> rows) {
            this.rows = rows;
            return this;
        }

        public DataTableComponentBuilder dataCellOptimizer(TextLengthOptimizer dataCellOptimizer) {
            this.dataCellOptimizer = dataCellOptimizer;
            this.dataCellOptimizer$set = true;
            return this;
        }

        public DataTableComponent build() {
            return new DataTableComponent(this.rows, this.dataCellOptimizer$set ? this.dataCellOptimizer : DataTableComponent.$default$dataCellOptimizer());
        }

        public String toString() {
            return "DataTableComponent.DataTableComponentBuilder(rows=" + this.rows + ", dataCellOptimizer=" + this.dataCellOptimizer + ")";
        }
    }
}

