/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.PieStyler;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.component.chart.ChartComponent;
import tech.grasshopper.pdf.component.chart.ChartDisplayer;
import tech.grasshopper.pdf.component.chart.ReportDonutChart;
import tech.grasshopper.pdf.component.decorator.BackgroundDecorator;
import tech.grasshopper.pdf.component.line.HorizontalLineComponent;
import tech.grasshopper.pdf.component.text.MultiLineTextComponent;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.report.Text;
import tech.grasshopper.pdf.util.DateUtil;

public class DetailedFeatureComponent
extends ChartComponent
implements DestinationAware {
    public static final int CONTENT_HEIGHT = 195;
    private Feature feature;
    private int startHeight;
    private static final PDFont NAME_FONT = ReportFont.BOLD_FONT;
    private static final int NAME_FONT_SIZE = 16;
    private static final int FEATURE_NAME_WIDTH = 400;
    private static final int PADDING = 5;
    private final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(16).spaceWidth(390).build();

    @Override
    public void display() {
        this.createHeader();
        this.createDuration();
        this.createScenariosData();
        this.createScenariosDonut();
        this.createStepsData();
        this.createStepsDonut();
        this.createEndLine();
    }

    @Override
    public Destination createDestination() {
        Destination destination = Destination.builder().name(this.feature.getName()).yCoord(this.startHeight - 15).page(this.page).build();
        this.feature.setDestination(destination.createPDPageDestination());
        return destination;
    }

    private void createHeader() {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedFeatureConfig().featureNameColor()).font(NAME_FONT).fontSize(16.0f).xoffset(50.0f).yoffset(this.startHeight - 30).text(this.featureNameTextOptimizer.optimizeText("(F) - " + this.feature.getName())).build());
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedFeatureConfig().startEndTimeColor()).font(ReportFont.ITALIC_FONT).fontSize(12.0f).xoffset(50.0f).yoffset(this.startHeight - 50).text("//  " + DateUtil.formatDateTimeWithMillis(this.feature.getStartTime()) + "  //  " + DateUtil.formatDateTimeWithMillis(this.feature.getEndTime()) + "  //").build());
        Collections.sort(this.feature.getTags());
        String tags = "@Tags - " + this.feature.getTags().stream().collect(Collectors.joining(" "));
        texts.add(Text.builder().font(ReportFont.REGULAR_FONT).fontSize(11.0f).textColor(this.reportConfig.getDetailedFeatureConfig().tagColor()).xoffset(50.0f).yoffset(this.startHeight - 70).text(this.featureNameTextOptimizer.optimizeText(tags)).build());
        ((MultiLineTextComponent)((MultiLineTextComponent.MultiLineTextComponentBuilder)((MultiLineTextComponent.MultiLineTextComponentBuilder)MultiLineTextComponent.builder().content(this.content)).texts(texts)).build()).display();
    }

    private void createDuration() {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedFeatureConfig().durationColor()).font(ReportFont.BOLD_ITALIC_FONT).fontSize(10.0f).xoffset(450.0f).yoffset(this.startHeight - 40).text("Duration").build());
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedFeatureConfig().durationColor()).font(ReportFont.BOLD_ITALIC_FONT).fontSize(11.0f).xoffset(450.0f).yoffset(this.startHeight - 60).text(DateUtil.durationValue(this.feature.calculatedDuration())).build());
        Component component = ((MultiLineTextComponent.MultiLineTextComponentBuilder)((MultiLineTextComponent.MultiLineTextComponentBuilder)MultiLineTextComponent.builder().content(this.content)).texts(texts)).build();
        component = ((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)BackgroundDecorator.builder().component(component)).content(this.content)).containerColor(this.reportConfig.getDetailedFeatureConfig().durationBackgroundColor())).xContainerBottomLeft(445.0f)).yContainerBottomLeft(this.startHeight - 70)).containerWidth(100.0f)).containerHeight(45.0f)).build();
        component.display();
    }

    private void createScenariosData() {
        this.createData("Scenarios", this.feature.getTotalScenarios(), this.feature.getPassedScenarios(), this.feature.getFailedScenarios(), this.feature.getSkippedScenarios(), 55, 65);
    }

    private void createScenariosDonut() {
        ReportDonutChart chart = new ReportDonutChart(100, 100);
        this.updateChartStyler((PieStyler)chart.getStyler());
        HashMap<String, Number> data = new HashMap<String, Number>();
        data.put("Passed", this.feature.getPassedScenarios());
        data.put("Failed", this.feature.getFailedScenarios());
        data.put("Skipped", this.feature.getSkippedScenarios());
        chart.updateData(data);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)chart)).xBottomLeft(145.0f)).yBottomLeft(this.startHeight - 180)).build()).display();
    }

    private void createStepsData() {
        this.createData("Steps", this.feature.getTotalSteps(), this.feature.getPassedSteps(), this.feature.getFailedSteps(), this.feature.getSkippedSteps(), 300, 65);
    }

    private void createStepsDonut() {
        ReportDonutChart chart = new ReportDonutChart(100, 100);
        this.updateChartStyler((PieStyler)chart.getStyler());
        HashMap<String, Number> data = new HashMap<String, Number>();
        data.put("Passed", this.feature.getPassedSteps());
        data.put("Failed", this.feature.getFailedSteps());
        data.put("Skipped", this.feature.getSkippedSteps());
        chart.updateData(data);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)chart)).xBottomLeft(390.0f)).yBottomLeft(this.startHeight - 180)).build()).display();
    }

    private void createEndLine() {
        ((HorizontalLineComponent)((HorizontalLineComponent.HorizontalLineComponentBuilder)((HorizontalLineComponent.HorizontalLineComponentBuilder)((HorizontalLineComponent.HorizontalLineComponentBuilder)((HorizontalLineComponent.HorizontalLineComponentBuilder)((HorizontalLineComponent.HorizontalLineComponentBuilder)HorizontalLineComponent.builder().content(this.content)).color(Color.GRAY)).xStartCord(50)).xEndCord(550)).yCord(this.startHeight - 190)).build()).display();
    }

    private void createData(String title, int total, int pass, int fail, int skip, int xOffset, int width) {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedFeatureConfig().dataHeaderColor()).font(ReportFont.BOLD_FONT).fontSize(11.0f).xoffset(xOffset).yoffset(this.startHeight - 95).text(title).build());
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedFeatureConfig().totalColor()).font(ReportFont.BOLD_FONT).fontSize(9.0f).xoffset(xOffset).yoffset(this.startHeight - 115).text("Total " + total).build());
        texts.add(Text.builder().textColor(this.reportConfig.passedColor()).font(ReportFont.BOLD_FONT).fontSize(9.0f).xoffset(xOffset).yoffset(this.startHeight - 135).text("Pass " + pass).build());
        texts.add(Text.builder().textColor(this.reportConfig.failedColor()).font(ReportFont.BOLD_FONT).fontSize(9.0f).xoffset(xOffset).yoffset(this.startHeight - 155).text("Fail " + fail).build());
        texts.add(Text.builder().textColor(this.reportConfig.skippedColor()).font(ReportFont.BOLD_FONT).fontSize(9.0f).xoffset(xOffset).yoffset(this.startHeight - 175).text("Skip " + skip).build());
        Component component = ((MultiLineTextComponent.MultiLineTextComponentBuilder)((MultiLineTextComponent.MultiLineTextComponentBuilder)MultiLineTextComponent.builder().content(this.content)).texts(texts)).build();
        component = ((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)BackgroundDecorator.builder().component(component)).content(this.content)).containerColor(this.reportConfig.getDetailedFeatureConfig().dataBackgroundColor())).xContainerBottomLeft(xOffset - 5)).yContainerBottomLeft(this.startHeight - 180)).containerWidth(width)).containerHeight(100.0f)).build();
        component.display();
    }

    private void updateChartStyler(PieStyler styler) {
        styler.setSumFontSize(16.0f);
        styler.setDonutThickness(0.4);
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
    }

    protected DetailedFeatureComponent(DetailedFeatureComponentBuilder<?, ?> b) {
        super((ChartComponent.ChartComponentBuilder<?, ?>)b);
        this.feature = ((DetailedFeatureComponentBuilder)b).feature;
        this.startHeight = ((DetailedFeatureComponentBuilder)b).startHeight;
    }

    public static DetailedFeatureComponentBuilder<?, ?> builder() {
        return new DetailedFeatureComponentBuilderImpl();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int getStartHeight() {
        return this.startHeight;
    }

    public TextLengthOptimizer getFeatureNameTextOptimizer() {
        return this.featureNameTextOptimizer;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public void setStartHeight(int startHeight) {
        this.startHeight = startHeight;
    }

    @Override
    public String toString() {
        return "DetailedFeatureComponent(feature=" + this.getFeature() + ", startHeight=" + this.getStartHeight() + ", featureNameTextOptimizer=" + this.getFeatureNameTextOptimizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedFeatureComponent)) {
            return false;
        }
        DetailedFeatureComponent other = (DetailedFeatureComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature)) {
            return false;
        }
        if (this.getStartHeight() != other.getStartHeight()) {
            return false;
        }
        TextLengthOptimizer this$featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        TextLengthOptimizer other$featureNameTextOptimizer = other.getFeatureNameTextOptimizer();
        return !(this$featureNameTextOptimizer == null ? other$featureNameTextOptimizer != null : !((Object)this$featureNameTextOptimizer).equals(other$featureNameTextOptimizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DetailedFeatureComponent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        result = result * 59 + this.getStartHeight();
        TextLengthOptimizer $featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        result = result * 59 + ($featureNameTextOptimizer == null ? 43 : ((Object)$featureNameTextOptimizer).hashCode());
        return result;
    }

    public static abstract class DetailedFeatureComponentBuilder<C extends DetailedFeatureComponent, B extends DetailedFeatureComponentBuilder<C, B>>
    extends ChartComponent.ChartComponentBuilder<C, B> {
        private Feature feature;
        private int startHeight;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B feature(Feature feature) {
            this.feature = feature;
            return (B)this.self();
        }

        public B startHeight(int startHeight) {
            this.startHeight = startHeight;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DetailedFeatureComponent.DetailedFeatureComponentBuilder(super=" + super.toString() + ", feature=" + this.feature + ", startHeight=" + this.startHeight + ")";
        }
    }

    private static final class DetailedFeatureComponentBuilderImpl
    extends DetailedFeatureComponentBuilder<DetailedFeatureComponent, DetailedFeatureComponentBuilderImpl> {
        private DetailedFeatureComponentBuilderImpl() {
        }

        @Override
        protected DetailedFeatureComponentBuilderImpl self() {
            return this;
        }

        @Override
        public DetailedFeatureComponent build() {
            return new DetailedFeatureComponent(this);
        }
    }
}

