/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import tech.grasshopper.pdf.chapter.page.Page;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.exception.PdfReportException;

public class DetailedPage
extends Page {
    private static final Logger logger = Logger.getLogger(DetailedPage.class.getName());
    public static final int CONTENT_HEIGHT = 750;
    public static final int CONTENT_Y_START = 800;
    private List<Component> components;

    @Override
    public void createPage() {
        try {
            PDPage page = new PDPage(PDRectangle.A4);
            this.document.addPage(page);
            this.content = new PDPageContentStream(this.document, page);
            this.components.forEach(c -> {
                c.setContent(this.content);
                c.setPage(page);
                c.display();
                if (c instanceof DestinationAware) {
                    ((DestinationAware)((Object)c)).createDestination();
                }
            });
            this.content.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }

    protected DetailedPage(DetailedPageBuilder<?, ?> b) {
        super(b);
        this.components = ((DetailedPageBuilder)b).components;
    }

    public static DetailedPageBuilder<?, ?> builder() {
        return new DetailedPageBuilderImpl();
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    @Override
    public String toString() {
        return "DetailedPage(components=" + this.getComponents() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedPage)) {
            return false;
        }
        DetailedPage other = (DetailedPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DetailedPage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    public static abstract class DetailedPageBuilder<C extends DetailedPage, B extends DetailedPageBuilder<C, B>>
    extends Page.PageBuilder<C, B> {
        private List<Component> components;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B components(List<Component> components) {
            this.components = components;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DetailedPage.DetailedPageBuilder(super=" + super.toString() + ", components=" + this.components + ")";
        }
    }

    private static final class DetailedPageBuilderImpl
    extends DetailedPageBuilder<DetailedPage, DetailedPageBuilderImpl> {
        private DetailedPageBuilderImpl() {
        }

        @Override
        protected DetailedPageBuilderImpl self() {
            return this;
        }

        @Override
        public DetailedPage build() {
            return new DetailedPage(this);
        }
    }
}

