/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.PieStyler;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.component.chart.ChartComponent;
import tech.grasshopper.pdf.component.chart.ChartDisplayer;
import tech.grasshopper.pdf.component.chart.ReportBarChart;
import tech.grasshopper.pdf.component.chart.ReportDonutChart;
import tech.grasshopper.pdf.component.decorator.BackgroundDecorator;
import tech.grasshopper.pdf.component.text.MultiLineTextComponent;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.pojo.report.Text;
import tech.grasshopper.pdf.util.DateUtil;

public class DetailedScenarioComponent
extends ChartComponent
implements DestinationAware {
    public static final int CONTENT_HEIGHT = 195;
    public static final int MAX_CHART_COUNT = 15;
    private Scenario scenario;
    private Feature feature;
    private int startHeight;
    private static final PDFont FEATURE_NAME_FONT = ReportFont.REGULAR_FONT;
    private static final int FEATURE_NAME_FONT_SIZE = 12;
    private static final PDFont SCENARIO_NAME_FONT = ReportFont.BOLD_FONT;
    private static final int SCENARIO_NAME_FONT_SIZE = 15;
    private static final int NAME_WIDTH = 400;
    private static final int PADDING = 5;
    private final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(FEATURE_NAME_FONT).fontsize(12).spaceWidth(390).build();
    private final TextLengthOptimizer scenarioNameTextOptimizer = TextLengthOptimizer.builder().font(SCENARIO_NAME_FONT).fontsize(15).spaceWidth(390).build();

    @Override
    public void display() {
        this.createHeader();
        this.createDuration();
        this.createStepsChart();
        this.createStepsData();
        this.createStepsDonut();
    }

    @Override
    public Destination createDestination() {
        Destination destination = Destination.builder().name(this.scenario.getName()).yCoord(this.startHeight - 30).page(this.page).build();
        this.scenario.setDestination(destination.createPDPageDestination());
        return destination;
    }

    private void createHeader() {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedScenarioConfig().featureNameColor()).font(FEATURE_NAME_FONT).fontSize(12.0f).xoffset(50.0f).yoffset(this.startHeight - 25).text(this.featureNameTextOptimizer.optimizeText("(F) - " + this.feature.getName())).build());
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedScenarioConfig().scenarioNameColor()).font(SCENARIO_NAME_FONT).fontSize(15.0f).xoffset(50.0f).yoffset(this.startHeight - 45).text(this.scenarioNameTextOptimizer.optimizeText("(S) - " + this.scenario.getName())).build());
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedScenarioConfig().startEndTimeColor()).font(ReportFont.ITALIC_FONT).fontSize(12.0f).xoffset(50.0f).yoffset(this.startHeight - 60).text("//  " + DateUtil.formatDateTimeWithMillis(this.scenario.getStartTime()) + "  //  " + DateUtil.formatDateTimeWithMillis(this.scenario.getEndTime()) + "  //").build());
        Collections.sort(this.scenario.getTags());
        String tags = "@Tags - " + this.scenario.getTags().stream().collect(Collectors.joining(" "));
        texts.add(Text.builder().font(ReportFont.REGULAR_FONT).fontSize(11.0f).textColor(this.reportConfig.getDetailedScenarioConfig().tagColor()).xoffset(50.0f).yoffset(this.startHeight - 75).text(this.featureNameTextOptimizer.optimizeText(tags)).build());
        ((MultiLineTextComponent)((MultiLineTextComponent.MultiLineTextComponentBuilder)((MultiLineTextComponent.MultiLineTextComponentBuilder)MultiLineTextComponent.builder().content(this.content)).texts(texts)).build()).display();
    }

    private void createDuration() {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedScenarioConfig().durationColor()).font(ReportFont.BOLD_ITALIC_FONT).fontSize(10.0f).xoffset(450.0f).yoffset(this.startHeight - 35).text("Duration").build());
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedScenarioConfig().durationColor()).font(ReportFont.BOLD_ITALIC_FONT).fontSize(11.0f).xoffset(450.0f).yoffset(this.startHeight - 55).text(DateUtil.durationValue(this.scenario.getStartTime(), this.scenario.getEndTime())).build());
        Component component = ((MultiLineTextComponent.MultiLineTextComponentBuilder)((MultiLineTextComponent.MultiLineTextComponentBuilder)MultiLineTextComponent.builder().content(this.content)).texts(texts)).build();
        component = ((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)BackgroundDecorator.builder().component(component)).content(this.content)).containerColor(this.reportConfig.getDetailedScenarioConfig().durationBackgroundColor())).xContainerBottomLeft(445.0f)).yContainerBottomLeft(this.startHeight - 65)).containerWidth(100.0f)).containerHeight(45.0f)).build();
        component.display();
    }

    private void createStepsChart() {
        ReportBarChart chart = new ReportBarChart(330, 105);
        List<Double> data = this.scenario.getSteps().stream().map(s -> DateUtil.duration(s.getStartTime(), s.getEndTime())).collect(Collectors.toList());
        if (data.size() > 15) {
            data = data.subList(0, 15);
        }
        this.updateBarChartStyler((CategoryStyler)chart.getStyler(), data);
        chart.updateData(data);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)chart)).xBottomLeft(50.0f)).yBottomLeft(this.startHeight - 185)).build()).display();
    }

    private void createStepsData() {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedScenarioConfig().dataHeaderColor()).font(ReportFont.BOLD_FONT).fontSize(11.0f).xoffset(395.0f).yoffset(this.startHeight - 95).text("Steps").build());
        texts.add(Text.builder().textColor(this.reportConfig.getDetailedScenarioConfig().totalColor()).font(ReportFont.BOLD_FONT).fontSize(9.0f).xoffset(395.0f).yoffset(this.startHeight - 115).text("Total " + this.scenario.getTotalSteps()).build());
        texts.add(Text.builder().textColor(this.reportConfig.passedColor()).font(ReportFont.BOLD_FONT).fontSize(9.0f).xoffset(395.0f).yoffset(this.startHeight - 135).text("Pass " + this.scenario.getPassedSteps()).build());
        texts.add(Text.builder().textColor(this.reportConfig.failedColor()).font(ReportFont.BOLD_FONT).fontSize(9.0f).xoffset(395.0f).yoffset(this.startHeight - 155).text("Fail " + this.scenario.getFailedSteps()).build());
        texts.add(Text.builder().textColor(this.reportConfig.skippedColor()).font(ReportFont.BOLD_FONT).fontSize(9.0f).xoffset(395.0f).yoffset(this.startHeight - 175).text("Skip " + this.scenario.getSkippedSteps()).build());
        Component component = ((MultiLineTextComponent.MultiLineTextComponentBuilder)((MultiLineTextComponent.MultiLineTextComponentBuilder)MultiLineTextComponent.builder().content(this.content)).texts(texts)).build();
        component = ((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)BackgroundDecorator.builder().component(component)).content(this.content)).containerColor(this.reportConfig.getDetailedScenarioConfig().dataBackgroundColor())).xContainerBottomLeft(390.0f)).yContainerBottomLeft(this.startHeight - 180)).containerWidth(50.0f)).containerHeight(100.0f)).build();
        component.display();
    }

    private void createStepsDonut() {
        ReportDonutChart chart = new ReportDonutChart(100, 100);
        this.updateDonutChartStyler((PieStyler)chart.getStyler());
        HashMap<String, Number> data = new HashMap<String, Number>();
        data.put("Passed", this.scenario.getPassedSteps());
        data.put("Failed", this.scenario.getFailedSteps());
        data.put("Skipped", this.scenario.getSkippedSteps());
        chart.updateData(data);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)chart)).xBottomLeft(450.0f)).yBottomLeft(this.startHeight - 180)).build()).display();
    }

    private void updateDonutChartStyler(PieStyler styler) {
        styler.setSumFontSize(16.0f);
        styler.setDonutThickness(0.4);
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
    }

    private void updateBarChartStyler(CategoryStyler styler, List<Double> data) {
        double maxVal = (Double)data.stream().max(Comparator.naturalOrder()).get();
        if (maxVal <= 0.25) {
            styler.setYAxisMax(Double.valueOf(0.5));
        } else if (maxVal <= 0.5) {
            styler.setYAxisMax(Double.valueOf(0.75));
        } else {
            styler.setYAxisMax(Double.valueOf(Math.floor(maxVal) + 1.0));
        }
        styler.setSeriesColors(new Color[]{this.reportConfig.getDetailedScenarioConfig().stepChartBarColor()});
    }

    protected DetailedScenarioComponent(DetailedScenarioComponentBuilder<?, ?> b) {
        super((ChartComponent.ChartComponentBuilder<?, ?>)b);
        this.scenario = ((DetailedScenarioComponentBuilder)b).scenario;
        this.feature = ((DetailedScenarioComponentBuilder)b).feature;
        this.startHeight = ((DetailedScenarioComponentBuilder)b).startHeight;
    }

    public static DetailedScenarioComponentBuilder<?, ?> builder() {
        return new DetailedScenarioComponentBuilderImpl();
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int getStartHeight() {
        return this.startHeight;
    }

    public TextLengthOptimizer getFeatureNameTextOptimizer() {
        return this.featureNameTextOptimizer;
    }

    public TextLengthOptimizer getScenarioNameTextOptimizer() {
        return this.scenarioNameTextOptimizer;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public void setStartHeight(int startHeight) {
        this.startHeight = startHeight;
    }

    @Override
    public String toString() {
        return "DetailedScenarioComponent(scenario=" + this.getScenario() + ", feature=" + this.getFeature() + ", startHeight=" + this.getStartHeight() + ", featureNameTextOptimizer=" + this.getFeatureNameTextOptimizer() + ", scenarioNameTextOptimizer=" + this.getScenarioNameTextOptimizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedScenarioComponent)) {
            return false;
        }
        DetailedScenarioComponent other = (DetailedScenarioComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Scenario this$scenario = this.getScenario();
        Scenario other$scenario = other.getScenario();
        if (this$scenario == null ? other$scenario != null : !((Object)this$scenario).equals(other$scenario)) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature)) {
            return false;
        }
        if (this.getStartHeight() != other.getStartHeight()) {
            return false;
        }
        TextLengthOptimizer this$featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        TextLengthOptimizer other$featureNameTextOptimizer = other.getFeatureNameTextOptimizer();
        if (this$featureNameTextOptimizer == null ? other$featureNameTextOptimizer != null : !((Object)this$featureNameTextOptimizer).equals(other$featureNameTextOptimizer)) {
            return false;
        }
        TextLengthOptimizer this$scenarioNameTextOptimizer = this.getScenarioNameTextOptimizer();
        TextLengthOptimizer other$scenarioNameTextOptimizer = other.getScenarioNameTextOptimizer();
        return !(this$scenarioNameTextOptimizer == null ? other$scenarioNameTextOptimizer != null : !((Object)this$scenarioNameTextOptimizer).equals(other$scenarioNameTextOptimizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DetailedScenarioComponent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Scenario $scenario = this.getScenario();
        result = result * 59 + ($scenario == null ? 43 : ((Object)$scenario).hashCode());
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        result = result * 59 + this.getStartHeight();
        TextLengthOptimizer $featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        result = result * 59 + ($featureNameTextOptimizer == null ? 43 : ((Object)$featureNameTextOptimizer).hashCode());
        TextLengthOptimizer $scenarioNameTextOptimizer = this.getScenarioNameTextOptimizer();
        result = result * 59 + ($scenarioNameTextOptimizer == null ? 43 : ((Object)$scenarioNameTextOptimizer).hashCode());
        return result;
    }

    public static abstract class DetailedScenarioComponentBuilder<C extends DetailedScenarioComponent, B extends DetailedScenarioComponentBuilder<C, B>>
    extends ChartComponent.ChartComponentBuilder<C, B> {
        private Scenario scenario;
        private Feature feature;
        private int startHeight;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B scenario(Scenario scenario) {
            this.scenario = scenario;
            return (B)this.self();
        }

        public B feature(Feature feature) {
            this.feature = feature;
            return (B)this.self();
        }

        public B startHeight(int startHeight) {
            this.startHeight = startHeight;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DetailedScenarioComponent.DetailedScenarioComponentBuilder(super=" + super.toString() + ", scenario=" + this.scenario + ", feature=" + this.feature + ", startHeight=" + this.startHeight + ")";
        }
    }

    private static final class DetailedScenarioComponentBuilderImpl
    extends DetailedScenarioComponentBuilder<DetailedScenarioComponent, DetailedScenarioComponentBuilderImpl> {
        private DetailedScenarioComponentBuilderImpl() {
        }

        @Override
        protected DetailedScenarioComponentBuilderImpl self() {
            return this;
        }

        @Override
        public DetailedScenarioComponent build() {
            return new DetailedScenarioComponent(this);
        }
    }
}

