/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.chapter.detailed.StepOrHookComponent;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;

public class DocStringComponent
implements StepOrHookComponent {
    private String docString;
    private static final int LINE_HEIGHT = 15;
    private static final int MAX_LINES = 4;
    private static final PDFont FONT = ReportFont.REGULAR_FONT;
    private static final int FONT_SIZE = 8;
    private static final int WIDTH = 290;
    private final TextLengthOptimizer docStringOptimizer;

    @Override
    public int componentHeight() {
        int height = 0;
        if (this.docString != null) {
            String[] lines = this.docString.split("\\r?\\n");
            height = lines.length <= 4 ? lines.length * 15 : 60;
        }
        return height;
    }

    @Override
    public void componentText(ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder) {
        if (this.docString != null) {
            String[] lines = this.docString.split("\\r?\\n");
            int index = lines.length <= 4 ? lines.length : 4;
            int i = 0;
            while (i < index) {
                String lineData = "    " + lines[i];
                paragraphBuilder.append(StyledText.builder().text(this.docStringOptimizer.optimizeText(lineData)).font(FONT).fontSize(Float.valueOf(8.0f)).build()).appendNewLine();
                ++i;
            }
        }
    }

    private static TextLengthOptimizer $default$docStringOptimizer() {
        return TextLengthOptimizer.builder().font(FONT).fontsize(8).spaceWidth(290).build();
    }

    DocStringComponent(String docString, TextLengthOptimizer docStringOptimizer) {
        this.docString = docString;
        this.docStringOptimizer = docStringOptimizer;
    }

    public static DocStringComponentBuilder builder() {
        return new DocStringComponentBuilder();
    }

    public String getDocString() {
        return this.docString;
    }

    public TextLengthOptimizer getDocStringOptimizer() {
        return this.docStringOptimizer;
    }

    public void setDocString(String docString) {
        this.docString = docString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocStringComponent)) {
            return false;
        }
        DocStringComponent other = (DocStringComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$docString = this.getDocString();
        String other$docString = other.getDocString();
        if (this$docString == null ? other$docString != null : !this$docString.equals(other$docString)) {
            return false;
        }
        TextLengthOptimizer this$docStringOptimizer = this.getDocStringOptimizer();
        TextLengthOptimizer other$docStringOptimizer = other.getDocStringOptimizer();
        return !(this$docStringOptimizer == null ? other$docStringOptimizer != null : !((Object)this$docStringOptimizer).equals(other$docStringOptimizer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocStringComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $docString = this.getDocString();
        result = result * 59 + ($docString == null ? 43 : $docString.hashCode());
        TextLengthOptimizer $docStringOptimizer = this.getDocStringOptimizer();
        result = result * 59 + ($docStringOptimizer == null ? 43 : ((Object)$docStringOptimizer).hashCode());
        return result;
    }

    public String toString() {
        return "DocStringComponent(docString=" + this.getDocString() + ", docStringOptimizer=" + this.getDocStringOptimizer() + ")";
    }

    public static class DocStringComponentBuilder {
        private String docString;
        private TextLengthOptimizer docStringOptimizer;
        private boolean docStringOptimizer$set;

        DocStringComponentBuilder() {
        }

        public DocStringComponentBuilder docString(String docString) {
            this.docString = docString;
            return this;
        }

        public DocStringComponentBuilder docStringOptimizer(TextLengthOptimizer docStringOptimizer) {
            this.docStringOptimizer = docStringOptimizer;
            this.docStringOptimizer$set = true;
            return this;
        }

        public DocStringComponent build() {
            return new DocStringComponent(this.docString, this.docStringOptimizer$set ? this.docStringOptimizer : DocStringComponent.$default$docStringOptimizer());
        }

        public String toString() {
            return "DocStringComponent.DocStringComponentBuilder(docString=" + this.docString + ", docStringOptimizer=" + this.docStringOptimizer + ")";
        }
    }
}

