/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.chapter.detailed.StepOrHookComponent;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.StackTraceSanitizer;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;

public class ErrorMessageComponent
implements StepOrHookComponent {
    private String stackTrace;
    private boolean hasRowOrString;
    private Color textColor;
    private static final int ERROR_MSG_LINE_HEIGHT = 15;
    private static final PDFont FONT = ReportFont.REGULAR_FONT;
    private static final int FONT_SIZE = 9;
    private static final int WIDTH = 290;
    private static final int MAX_EXCEPTION_LINES = 10;
    private final TextLengthOptimizer messageOptimizer = TextLengthOptimizer.builder().font(FONT).fontsize(9).spaceWidth(290).build();

    @Override
    public int componentHeight() {
        int height = 0;
        if (this.stackTrace != null && !this.stackTrace.isEmpty()) {
            String[] lines = this.stackTrace.split("\\r?\\n");
            height = (lines.length > 10 ? 10 : lines.length) * 15;
        }
        return height;
    }

    @Override
    public void componentText(ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder) {
        StackTraceSanitizer sanitizer = StackTraceSanitizer.builder().font(FONT).build();
        if (this.stackTrace != null && !this.stackTrace.isEmpty()) {
            String[] lines = this.stackTrace.split("\\r?\\n");
            int dispayCount = lines.length > 10 ? 10 : lines.length;
            int i = 0;
            while (i < dispayCount) {
                String sanitizedLine = sanitizer.sanitizeText(lines[i]);
                paragraphBuilder.append(StyledText.builder().text(this.messageOptimizer.optimizeText(sanitizedLine)).font(FONT).fontSize(Float.valueOf(9.0f)).color(this.textColor).build()).appendNewLine();
                ++i;
            }
        }
    }

    private static String $default$stackTrace() {
        return "";
    }

    private static boolean $default$hasRowOrString() {
        return false;
    }

    private static Color $default$textColor() {
        return Color.RED;
    }

    ErrorMessageComponent(String stackTrace, boolean hasRowOrString, Color textColor) {
        this.stackTrace = stackTrace;
        this.hasRowOrString = hasRowOrString;
        this.textColor = textColor;
    }

    public static ErrorMessageComponentBuilder builder() {
        return new ErrorMessageComponentBuilder();
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean isHasRowOrString() {
        return this.hasRowOrString;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public TextLengthOptimizer getMessageOptimizer() {
        return this.messageOptimizer;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setHasRowOrString(boolean hasRowOrString) {
        this.hasRowOrString = hasRowOrString;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorMessageComponent)) {
            return false;
        }
        ErrorMessageComponent other = (ErrorMessageComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$stackTrace = this.getStackTrace();
        String other$stackTrace = other.getStackTrace();
        if (this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace)) {
            return false;
        }
        if (this.isHasRowOrString() != other.isHasRowOrString()) {
            return false;
        }
        Color this$textColor = this.getTextColor();
        Color other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !((Object)this$textColor).equals(other$textColor)) {
            return false;
        }
        TextLengthOptimizer this$messageOptimizer = this.getMessageOptimizer();
        TextLengthOptimizer other$messageOptimizer = other.getMessageOptimizer();
        return !(this$messageOptimizer == null ? other$messageOptimizer != null : !((Object)this$messageOptimizer).equals(other$messageOptimizer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorMessageComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
        result = result * 59 + (this.isHasRowOrString() ? 79 : 97);
        Color $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : ((Object)$textColor).hashCode());
        TextLengthOptimizer $messageOptimizer = this.getMessageOptimizer();
        result = result * 59 + ($messageOptimizer == null ? 43 : ((Object)$messageOptimizer).hashCode());
        return result;
    }

    public String toString() {
        return "ErrorMessageComponent(stackTrace=" + this.getStackTrace() + ", hasRowOrString=" + this.isHasRowOrString() + ", textColor=" + this.getTextColor() + ", messageOptimizer=" + this.getMessageOptimizer() + ")";
    }

    public static class ErrorMessageComponentBuilder {
        private String stackTrace;
        private boolean stackTrace$set;
        private boolean hasRowOrString;
        private boolean hasRowOrString$set;
        private Color textColor;
        private boolean textColor$set;

        ErrorMessageComponentBuilder() {
        }

        public ErrorMessageComponentBuilder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            this.stackTrace$set = true;
            return this;
        }

        public ErrorMessageComponentBuilder hasRowOrString(boolean hasRowOrString) {
            this.hasRowOrString = hasRowOrString;
            this.hasRowOrString$set = true;
            return this;
        }

        public ErrorMessageComponentBuilder textColor(Color textColor) {
            this.textColor = textColor;
            this.textColor$set = true;
            return this;
        }

        public ErrorMessageComponent build() {
            return new ErrorMessageComponent(this.stackTrace$set ? this.stackTrace : ErrorMessageComponent.$default$stackTrace(), this.hasRowOrString$set ? this.hasRowOrString : ErrorMessageComponent.$default$hasRowOrString(), this.textColor$set ? this.textColor : ErrorMessageComponent.$default$textColor());
        }

        public String toString() {
            return "ErrorMessageComponent.ErrorMessageComponentBuilder(stackTrace=" + this.stackTrace + ", hasRowOrString=" + this.hasRowOrString + ", textColor=" + this.textColor + ")";
        }
    }
}

