/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.chapter.detailed.StepOrHookComponent;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;

public class MediaMessageComponent
implements StepOrHookComponent {
    private List<String> mediaMessages;
    private boolean hasRowOrStringOrError;
    private Color textColor;
    private static final int MEDIA_MSG_LINE_HEIGHT = 15;
    private static final int ROWS_DOC_SEPARATOR_HEIGHT = 15;
    private static final int SEP_CHAR_REPEAT_COUNT = 95;
    private static final PDFont FONT = ReportFont.REGULAR_FONT;
    private static final int FONT_SIZE = 9;
    private static final int WIDTH = 290;
    private final TextLengthOptimizer messageOptimizer = TextLengthOptimizer.builder().font(FONT).fontsize(9).spaceWidth(290).build();

    @Override
    public int componentHeight() {
        int height = 0;
        if (this.mediaMessages != null && !this.mediaMessages.isEmpty()) {
            height = this.mediaMessages.size() * 15;
            if (this.hasRowOrStringOrError) {
                height += 15;
            }
        }
        return height;
    }

    @Override
    public void componentText(ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder) {
        if (this.mediaMessages != null) {
            if (this.hasRowOrStringOrError && !this.mediaMessages.isEmpty()) {
                paragraphBuilder.append(StyledText.builder().text(String.join((CharSequence)"", Collections.nCopies(95, "-"))).build()).appendNewLine();
            }
            for (String media : this.mediaMessages) {
                paragraphBuilder.append(StyledText.builder().text(this.messageOptimizer.optimizeText("Media saved - " + media)).fontSize(Float.valueOf(9.0f)).color(this.textColor).build()).appendNewLine();
            }
        }
    }

    private static boolean $default$hasRowOrStringOrError() {
        return false;
    }

    private static Color $default$textColor() {
        return Color.GRAY;
    }

    MediaMessageComponent(List<String> mediaMessages, boolean hasRowOrStringOrError, Color textColor) {
        this.mediaMessages = mediaMessages;
        this.hasRowOrStringOrError = hasRowOrStringOrError;
        this.textColor = textColor;
    }

    public static MediaMessageComponentBuilder builder() {
        return new MediaMessageComponentBuilder();
    }

    public List<String> getMediaMessages() {
        return this.mediaMessages;
    }

    public boolean isHasRowOrStringOrError() {
        return this.hasRowOrStringOrError;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public TextLengthOptimizer getMessageOptimizer() {
        return this.messageOptimizer;
    }

    public void setMediaMessages(List<String> mediaMessages) {
        this.mediaMessages = mediaMessages;
    }

    public void setHasRowOrStringOrError(boolean hasRowOrStringOrError) {
        this.hasRowOrStringOrError = hasRowOrStringOrError;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaMessageComponent)) {
            return false;
        }
        MediaMessageComponent other = (MediaMessageComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$mediaMessages = this.getMediaMessages();
        List<String> other$mediaMessages = other.getMediaMessages();
        if (this$mediaMessages == null ? other$mediaMessages != null : !((Object)this$mediaMessages).equals(other$mediaMessages)) {
            return false;
        }
        if (this.isHasRowOrStringOrError() != other.isHasRowOrStringOrError()) {
            return false;
        }
        Color this$textColor = this.getTextColor();
        Color other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !((Object)this$textColor).equals(other$textColor)) {
            return false;
        }
        TextLengthOptimizer this$messageOptimizer = this.getMessageOptimizer();
        TextLengthOptimizer other$messageOptimizer = other.getMessageOptimizer();
        return !(this$messageOptimizer == null ? other$messageOptimizer != null : !((Object)this$messageOptimizer).equals(other$messageOptimizer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MediaMessageComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $mediaMessages = this.getMediaMessages();
        result = result * 59 + ($mediaMessages == null ? 43 : ((Object)$mediaMessages).hashCode());
        result = result * 59 + (this.isHasRowOrStringOrError() ? 79 : 97);
        Color $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : ((Object)$textColor).hashCode());
        TextLengthOptimizer $messageOptimizer = this.getMessageOptimizer();
        result = result * 59 + ($messageOptimizer == null ? 43 : ((Object)$messageOptimizer).hashCode());
        return result;
    }

    public String toString() {
        return "MediaMessageComponent(mediaMessages=" + this.getMediaMessages() + ", hasRowOrStringOrError=" + this.isHasRowOrStringOrError() + ", textColor=" + this.getTextColor() + ", messageOptimizer=" + this.getMessageOptimizer() + ")";
    }

    public static class MediaMessageComponentBuilder {
        private List<String> mediaMessages;
        private boolean hasRowOrStringOrError;
        private boolean hasRowOrStringOrError$set;
        private Color textColor;
        private boolean textColor$set;

        MediaMessageComponentBuilder() {
        }

        public MediaMessageComponentBuilder mediaMessages(List<String> mediaMessages) {
            this.mediaMessages = mediaMessages;
            return this;
        }

        public MediaMessageComponentBuilder hasRowOrStringOrError(boolean hasRowOrStringOrError) {
            this.hasRowOrStringOrError = hasRowOrStringOrError;
            this.hasRowOrStringOrError$set = true;
            return this;
        }

        public MediaMessageComponentBuilder textColor(Color textColor) {
            this.textColor = textColor;
            this.textColor$set = true;
            return this;
        }

        public MediaMessageComponent build() {
            return new MediaMessageComponent(this.mediaMessages, this.hasRowOrStringOrError$set ? this.hasRowOrStringOrError : MediaMessageComponent.$default$hasRowOrStringOrError(), this.textColor$set ? this.textColor : MediaMessageComponent.$default$textColor());
        }

        public String toString() {
            return "MediaMessageComponent.MediaMessageComponentBuilder(mediaMessages=" + this.mediaMessages + ", hasRowOrStringOrError=" + this.hasRowOrStringOrError + ", textColor=" + this.textColor + ")";
        }
    }
}

