/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.chapter.detailed.HookRow;
import tech.grasshopper.pdf.chapter.detailed.StepRow;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Hook;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.pojo.cucumber.Step;

public abstract class StepOrHookRow {
    protected static final PDFont FONT = ReportFont.ITALIC_FONT;
    protected static final int FONT_SIZE = 10;
    protected static final int COLUMN_WIDTH = 315;
    protected static final int PADDING = 5;
    public static final int HEADER_ROW_HEIGHT = 22;
    public static final int NAME_ROW_HEIGHT = 20;
    protected String sNo;
    protected ReportConfig reportConfig;
    protected final TextLengthOptimizer nameOptimizer;

    protected Row generateRow() {
        return Row.builder().font(FONT).fontSize(Integer.valueOf(10)).height(Float.valueOf(this.getRowHeight())).horizontalAlignment(HorizontalAlignment.LEFT).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(this.getSerialNo()).fontSize(Integer.valueOf(9))).build()).add((AbstractCell)this.generateTextOutput()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.getStatus().toString()).textColor(this.getStatusColor(this.reportConfig))).fontSize(Integer.valueOf(9))).horizontalAlignment(HorizontalAlignment.CENTER)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(this.getDuration()).textColor(this.reportConfig.getDetailedStepHookConfig().durationColor())).build()).build();
    }

    protected String getSerialNo() {
        return this.sNo;
    }

    protected abstract int getRowHeight();

    protected abstract ParagraphCell generateTextOutput();

    protected abstract Status getStatus();

    protected Color getStatusColor(ReportConfig reportConfig) {
        Color color = Color.BLACK;
        Status status = this.getStatus();
        if (status == Status.PASSED) {
            color = reportConfig.passedColor();
        } else if (status == Status.FAILED) {
            color = reportConfig.failedColor();
        } else if (status == Status.SKIPPED) {
            color = reportConfig.skippedColor();
        }
        return color;
    }

    protected abstract String getDuration();

    protected abstract boolean dividerRequired();

    protected void generateName(ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder, String name, Color textColor) {
        StyledText stepTextStyler = StyledText.builder().text(this.nameOptimizer.optimizeText(name)).color(textColor).build();
        paragraphBuilder.append(stepTextStyler).appendNewLine(1.0f);
    }

    protected ParagraphCell generateParagraphCell(ParagraphCell.Paragraph.ParagraphBuilder paraBuilder) {
        return ((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().paddingLeft(5.0f)).paddingRight(5.0f)).lineSpacing(1.45f).paragraph(paraBuilder.build()).build();
    }

    protected int incrementSerialNumber(int sno) {
        return sno;
    }

    public int decrementStepCount(int cnt) {
        return cnt;
    }

    public static StepOrHookRow createStepOrHook(Step step) {
        return ((StepRow.StepRowBuilder)StepRow.builder().step(step)).build();
    }

    public static StepOrHookRow createStepOrHook(Hook hook) {
        return ((HookRow.HookRowBuilder)HookRow.builder().hook(hook)).build();
    }

    private static TextLengthOptimizer $default$nameOptimizer() {
        return TextLengthOptimizer.builder().font(FONT).fontsize(10).spaceWidth(305).build();
    }

    protected StepOrHookRow(StepOrHookRowBuilder<?, ?> b) {
        this.sNo = ((StepOrHookRowBuilder)b).sNo;
        this.reportConfig = ((StepOrHookRowBuilder)b).reportConfig;
        this.nameOptimizer = ((StepOrHookRowBuilder)b).nameOptimizer$set ? ((StepOrHookRowBuilder)b).nameOptimizer : StepOrHookRow.$default$nameOptimizer();
    }

    public String getSNo() {
        return this.sNo;
    }

    public ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public TextLengthOptimizer getNameOptimizer() {
        return this.nameOptimizer;
    }

    public void setSNo(String sNo) {
        this.sNo = sNo;
    }

    public void setReportConfig(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepOrHookRow)) {
            return false;
        }
        StepOrHookRow other = (StepOrHookRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sNo = this.getSNo();
        String other$sNo = other.getSNo();
        if (this$sNo == null ? other$sNo != null : !this$sNo.equals(other$sNo)) {
            return false;
        }
        ReportConfig this$reportConfig = this.getReportConfig();
        ReportConfig other$reportConfig = other.getReportConfig();
        if (this$reportConfig == null ? other$reportConfig != null : !((Object)this$reportConfig).equals(other$reportConfig)) {
            return false;
        }
        TextLengthOptimizer this$nameOptimizer = this.getNameOptimizer();
        TextLengthOptimizer other$nameOptimizer = other.getNameOptimizer();
        return !(this$nameOptimizer == null ? other$nameOptimizer != null : !((Object)this$nameOptimizer).equals(other$nameOptimizer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StepOrHookRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sNo = this.getSNo();
        result = result * 59 + ($sNo == null ? 43 : $sNo.hashCode());
        ReportConfig $reportConfig = this.getReportConfig();
        result = result * 59 + ($reportConfig == null ? 43 : ((Object)$reportConfig).hashCode());
        TextLengthOptimizer $nameOptimizer = this.getNameOptimizer();
        result = result * 59 + ($nameOptimizer == null ? 43 : ((Object)$nameOptimizer).hashCode());
        return result;
    }

    public String toString() {
        return "StepOrHookRow(sNo=" + this.getSNo() + ", reportConfig=" + this.getReportConfig() + ", nameOptimizer=" + this.getNameOptimizer() + ")";
    }

    public static abstract class StepOrHookRowBuilder<C extends StepOrHookRow, B extends StepOrHookRowBuilder<C, B>> {
        private String sNo;
        private ReportConfig reportConfig;
        private TextLengthOptimizer nameOptimizer;
        private boolean nameOptimizer$set;

        protected abstract B self();

        public abstract C build();

        public B sNo(String sNo) {
            this.sNo = sNo;
            return this.self();
        }

        public B reportConfig(ReportConfig reportConfig) {
            this.reportConfig = reportConfig;
            return this.self();
        }

        public B nameOptimizer(TextLengthOptimizer nameOptimizer) {
            this.nameOptimizer = nameOptimizer;
            this.nameOptimizer$set = true;
            return this.self();
        }

        public String toString() {
            return "StepOrHookRow.StepOrHookRowBuilder(sNo=" + this.sNo + ", reportConfig=" + this.reportConfig + ", nameOptimizer=" + this.nameOptimizer + ")";
        }
    }
}

