/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.feature;

import java.awt.Color;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import tech.grasshopper.pdf.chapter.feature.FeatureScenarioDetails;
import tech.grasshopper.pdf.chapter.feature.FeatureStackedBarChart;
import tech.grasshopper.pdf.chapter.page.PaginatedPage;
import tech.grasshopper.pdf.component.text.TextComponent;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.pojo.report.Text;

public class FeaturePage
extends PaginatedPage
implements DestinationAware {
    private static final Logger logger = Logger.getLogger(FeaturePage.class.getName());
    private PDPage page;

    @Override
    public void createPage() {
        try {
            this.page = new PDPage(PDRectangle.A4);
            this.document.addPage(this.page);
            this.content = new PDPageContentStream(this.document, this.page);
            this.createTitle();
            this.createStackedBarChart();
            this.createTable();
            this.collectPageAnnotations();
            this.createDestination();
            this.content.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }

    private void createTitle() {
        Text text = Text.builder().textColor(Color.LIGHT_GRAY).font(ReportFont.BOLD_ITALIC_FONT).fontSize(12.0f).xoffset(40.0f).yoffset(775.0f).text("FEATURES SUMMARY " + (this.paginationData.getItemFromIndex() + 1) + " - " + this.paginationData.getItemToIndex()).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    private void createStackedBarChart() {
        ((FeatureStackedBarChart)((FeatureStackedBarChart.FeatureStackedBarChartBuilder)((FeatureStackedBarChart.FeatureStackedBarChartBuilder)((FeatureStackedBarChart.FeatureStackedBarChartBuilder)((FeatureStackedBarChart.FeatureStackedBarChartBuilder)((FeatureStackedBarChart.FeatureStackedBarChartBuilder)((FeatureStackedBarChart.FeatureStackedBarChartBuilder)((FeatureStackedBarChart.FeatureStackedBarChartBuilder)FeatureStackedBarChart.builder().document(this.document)).content(this.content)).displayData(this.displayData)).reportConfig(this.reportConfig)).itemCount(this.paginationData.getItemsPerPage())).fromXData(this.paginationData.getItemFromIndex())).toXData(this.paginationData.getItemToIndex())).build()).display();
    }

    private void createTable() {
        ((FeatureScenarioDetails)((FeatureScenarioDetails.FeatureScenarioDetailsBuilder)((FeatureScenarioDetails.FeatureScenarioDetailsBuilder)((FeatureScenarioDetails.FeatureScenarioDetailsBuilder)((FeatureScenarioDetails.FeatureScenarioDetailsBuilder)FeatureScenarioDetails.builder().displayData(this.displayData)).content(this.content)).reportConfig(this.reportConfig)).paginationData(this.paginationData)).build()).display();
    }

    public void collectPageAnnotations() {
        if (this.reportConfig.isDisplayFeature() && this.reportConfig.isDisplayDetailed()) {
            ((FeatureScenarioDetails)((FeatureScenarioDetails.FeatureScenarioDetailsBuilder)((FeatureScenarioDetails.FeatureScenarioDetailsBuilder)((FeatureScenarioDetails.FeatureScenarioDetailsBuilder)FeatureScenarioDetails.builder().displayData(this.displayData)).content(this.content)).page(this.page)).build()).createAnnotationLinks();
        }
    }

    @Override
    public Destination createDestination() {
        Destination destination = Destination.builder().name("Features - " + (this.paginationData.getItemFromIndex() + 1) + " to " + this.paginationData.getItemToIndex()).yCoord(800).page(this.page).build();
        this.destinations.addFeatureChapterDestinations(destination);
        return destination;
    }

    protected FeaturePage(FeaturePageBuilder<?, ?> b) {
        super((PaginatedPage.PaginatedPageBuilder<?, ?>)b);
        this.page = ((FeaturePageBuilder)b).page;
    }

    public static FeaturePageBuilder<?, ?> builder() {
        return new FeaturePageBuilderImpl();
    }

    public PDPage getPage() {
        return this.page;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    @Override
    public String toString() {
        return "FeaturePage(page=" + this.getPage() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeaturePage)) {
            return false;
        }
        FeaturePage other = (FeaturePage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeaturePage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public static abstract class FeaturePageBuilder<C extends FeaturePage, B extends FeaturePageBuilder<C, B>>
    extends PaginatedPage.PaginatedPageBuilder<C, B> {
        private PDPage page;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B page(PDPage page) {
            this.page = page;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FeaturePage.FeaturePageBuilder(super=" + super.toString() + ", page=" + this.page + ")";
        }
    }

    private static final class FeaturePageBuilderImpl
    extends FeaturePageBuilder<FeaturePage, FeaturePageBuilderImpl> {
        private FeaturePageBuilderImpl() {
        }

        @Override
        protected FeaturePageBuilderImpl self() {
            return this;
        }

        @Override
        public FeaturePage build() {
            return new FeaturePage(this);
        }
    }
}

