/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.feature;

import java.awt.Color;
import java.util.stream.IntStream;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import tech.grasshopper.pdf.component.chart.ChartComponent;
import tech.grasshopper.pdf.component.chart.ChartDisplayer;
import tech.grasshopper.pdf.component.chart.ReportStackedBarChart;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.pojo.cucumber.Feature;

public class FeatureStackedBarChart
extends ChartComponent {
    private int itemCount;
    private int fromXData;
    private int toXData;

    @Override
    public void display() {
        this.createBarChart();
    }

    private void createBarChart() {
        int[] passed = new int[this.itemCount];
        int[] failed = new int[this.itemCount];
        int[] skipped = new int[this.itemCount];
        int[] xData = new int[this.itemCount];
        xData = IntStream.rangeClosed(this.fromXData + 1, this.fromXData + this.itemCount).toArray();
        ReportStackedBarChart chart = new ReportStackedBarChart(520, 300);
        chart.setYAxisTitle("# of Scenarios");
        this.updateBarChartStyler((CategoryStyler)chart.getStyler());
        this.createStackedBarChartData(passed, failed, skipped);
        chart.updateData(xData, passed, failed, skipped);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)chart)).xBottomLeft(40.0f)).yBottomLeft(460.0f)).build()).display();
    }

    private void updateBarChartStyler(CategoryStyler styler) {
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
    }

    private void createStackedBarChartData(int[] passed, int[] failed, int[] skipped) {
        FeatureData featureData = (FeatureData)this.displayData;
        int i = 0;
        while (i < featureData.getFeatures().size()) {
            Feature feature = featureData.getFeatures().get(i);
            passed[i] = feature.getPassedScenarios();
            failed[i] = feature.getFailedScenarios();
            skipped[i] = feature.getSkippedScenarios();
            ++i;
        }
    }

    protected FeatureStackedBarChart(FeatureStackedBarChartBuilder<?, ?> b) {
        super((ChartComponent.ChartComponentBuilder<?, ?>)b);
        this.itemCount = ((FeatureStackedBarChartBuilder)b).itemCount;
        this.fromXData = ((FeatureStackedBarChartBuilder)b).fromXData;
        this.toXData = ((FeatureStackedBarChartBuilder)b).toXData;
    }

    public static FeatureStackedBarChartBuilder<?, ?> builder() {
        return new FeatureStackedBarChartBuilderImpl();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public int getFromXData() {
        return this.fromXData;
    }

    public int getToXData() {
        return this.toXData;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public void setFromXData(int fromXData) {
        this.fromXData = fromXData;
    }

    public void setToXData(int toXData) {
        this.toXData = toXData;
    }

    @Override
    public String toString() {
        return "FeatureStackedBarChart(itemCount=" + this.getItemCount() + ", fromXData=" + this.getFromXData() + ", toXData=" + this.getToXData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureStackedBarChart)) {
            return false;
        }
        FeatureStackedBarChart other = (FeatureStackedBarChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getItemCount() != other.getItemCount()) {
            return false;
        }
        if (this.getFromXData() != other.getFromXData()) {
            return false;
        }
        return this.getToXData() == other.getToXData();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeatureStackedBarChart;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getItemCount();
        result = result * 59 + this.getFromXData();
        result = result * 59 + this.getToXData();
        return result;
    }

    public static abstract class FeatureStackedBarChartBuilder<C extends FeatureStackedBarChart, B extends FeatureStackedBarChartBuilder<C, B>>
    extends ChartComponent.ChartComponentBuilder<C, B> {
        private int itemCount;
        private int fromXData;
        private int toXData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B itemCount(int itemCount) {
            this.itemCount = itemCount;
            return (B)this.self();
        }

        public B fromXData(int fromXData) {
            this.fromXData = fromXData;
            return (B)this.self();
        }

        public B toXData(int toXData) {
            this.toXData = toXData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FeatureStackedBarChart.FeatureStackedBarChartBuilder(super=" + super.toString() + ", itemCount=" + this.itemCount + ", fromXData=" + this.fromXData + ", toXData=" + this.toXData + ")";
        }
    }

    private static final class FeatureStackedBarChartBuilderImpl
    extends FeatureStackedBarChartBuilder<FeatureStackedBarChart, FeatureStackedBarChartBuilderImpl> {
        private FeatureStackedBarChartBuilderImpl() {
        }

        @Override
        protected FeatureStackedBarChartBuilderImpl self() {
            return this;
        }

        @Override
        public FeatureStackedBarChart build() {
            return new FeatureStackedBarChart(this);
        }
    }
}

