/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.scenario;

import java.util.List;
import tech.grasshopper.pdf.chapter.PaginatedChapter;
import tech.grasshopper.pdf.chapter.page.PaginationData;
import tech.grasshopper.pdf.chapter.page.Paginator;
import tech.grasshopper.pdf.chapter.scenario.ScenarioPage;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;

public class ScenarioChapter
extends PaginatedChapter {
    private final int scenarioPerPage;
    private ScenarioData scenarioData;

    @Override
    public void createChapter() {
        this.scenarioData = (ScenarioData)this.displayData;
        Paginator paginator = Paginator.builder().itemsCount(this.scenarioData.getScenarios().size()).itemsPerPage(this.scenarioPerPage).chapter(this).build();
        paginator.paginate();
    }

    @Override
    public void generatePage(int fromIndex, int toIndex, int pageNum) {
        ((ScenarioPage)((ScenarioPage.ScenarioPageBuilder)((ScenarioPage.ScenarioPageBuilder)((ScenarioPage.ScenarioPageBuilder)((ScenarioPage.ScenarioPageBuilder)((ScenarioPage.ScenarioPageBuilder)ScenarioPage.builder().displayData(this.createPageData(fromIndex, toIndex))).document(this.document)).reportConfig(this.reportConfig)).destinations(this.destinations)).paginationData(PaginationData.builder().itemsPerPage(this.scenarioPerPage).itemFromIndex(fromIndex).itemToIndex(toIndex).build())).build()).createPage();
    }

    @Override
    public DisplayData createPageData(int fromIndex, int toIndex) {
        List<Scenario> pageScenarios = this.scenarioData.getScenarios().subList(fromIndex, toIndex);
        return ScenarioData.builder().scenarios(pageScenarios).build();
    }

    protected ScenarioChapter(ScenarioChapterBuilder<?, ?> b) {
        super((PaginatedChapter.PaginatedChapterBuilder<?, ?>)b);
        this.scenarioPerPage = this.reportConfig.getScenarioConfig().getItemcount();
        this.scenarioData = ((ScenarioChapterBuilder)b).scenarioData;
    }

    public static ScenarioChapterBuilder<?, ?> builder() {
        return new ScenarioChapterBuilderImpl();
    }

    public int getScenarioPerPage() {
        return this.scenarioPerPage;
    }

    public ScenarioData getScenarioData() {
        return this.scenarioData;
    }

    public void setScenarioData(ScenarioData scenarioData) {
        this.scenarioData = scenarioData;
    }

    @Override
    public String toString() {
        return "ScenarioChapter(scenarioPerPage=" + this.getScenarioPerPage() + ", scenarioData=" + this.getScenarioData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScenarioChapter)) {
            return false;
        }
        ScenarioChapter other = (ScenarioChapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScenarioPerPage() != other.getScenarioPerPage()) {
            return false;
        }
        ScenarioData this$scenarioData = this.getScenarioData();
        ScenarioData other$scenarioData = other.getScenarioData();
        return !(this$scenarioData == null ? other$scenarioData != null : !((Object)this$scenarioData).equals(other$scenarioData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScenarioChapter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getScenarioPerPage();
        ScenarioData $scenarioData = this.getScenarioData();
        result = result * 59 + ($scenarioData == null ? 43 : ((Object)$scenarioData).hashCode());
        return result;
    }

    public static abstract class ScenarioChapterBuilder<C extends ScenarioChapter, B extends ScenarioChapterBuilder<C, B>>
    extends PaginatedChapter.PaginatedChapterBuilder<C, B> {
        private ScenarioData scenarioData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B scenarioData(ScenarioData scenarioData) {
            this.scenarioData = scenarioData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScenarioChapter.ScenarioChapterBuilder(super=" + super.toString() + ", scenarioData=" + this.scenarioData + ")";
        }
    }

    private static final class ScenarioChapterBuilderImpl
    extends ScenarioChapterBuilder<ScenarioChapter, ScenarioChapterBuilderImpl> {
        private ScenarioChapterBuilderImpl() {
        }

        @Override
        protected ScenarioChapterBuilderImpl self() {
            return this;
        }

        @Override
        public ScenarioChapter build() {
            return new ScenarioChapter(this);
        }
    }
}

