/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.summary;

import java.util.ArrayList;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.component.decorator.BackgroundDecorator;
import tech.grasshopper.pdf.component.text.MultiLineTextComponent;
import tech.grasshopper.pdf.data.SummaryData;
import tech.grasshopper.pdf.pojo.report.Text;

public class SummaryChartData
extends Component {
    private SummaryData summaryData;

    @Override
    public void display() {
        this.summaryData = (SummaryData)this.displayData;
        this.createFeaturesDataTextBox();
        this.createScenariosDataTextBox();
        this.createStepsDataTextBox();
    }

    private void createFeaturesDataTextBox() {
        this.createDataTextBox(this.summaryData.getPassedFeatures(), this.summaryData.getFailedFeatures(), this.summaryData.getSkippedFeatures(), 40.0f, 45.0f);
    }

    private void createScenariosDataTextBox() {
        this.createDataTextBox(this.summaryData.getPassedScenarios(), this.summaryData.getFailedScenarios(), this.summaryData.getSkippedScenarios(), 220.0f, 225.0f);
    }

    private void createStepsDataTextBox() {
        this.createDataTextBox(this.summaryData.getPassedSteps(), this.summaryData.getFailedSteps(), this.summaryData.getSkippedSteps(), 400.0f, 405.0f);
    }

    private void createDataTextBox(Number passed, Number failed, Number skipped, float xBoxOffset, float xOffset) {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().textColor(this.reportConfig.passedColor()).fontSize(12.0f).xoffset(xOffset).yoffset(380.0f).text("Passed - " + passed).build());
        texts.add(Text.builder().textColor(this.reportConfig.failedColor()).fontSize(12.0f).xoffset(xOffset).yoffset(360.0f).text("Failed - " + failed).build());
        texts.add(Text.builder().textColor(this.reportConfig.skippedColor()).fontSize(12.0f).xoffset(xOffset).yoffset(340.0f).text("Skipped - " + skipped).build());
        Component component = ((MultiLineTextComponent.MultiLineTextComponentBuilder)((MultiLineTextComponent.MultiLineTextComponentBuilder)MultiLineTextComponent.builder().content(this.content)).texts(texts)).build();
        component = ((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)BackgroundDecorator.builder().component(component)).content(this.content)).containerColor(this.reportConfig.getSummaryConfig().dataBackgroundColor())).xContainerBottomLeft(xBoxOffset)).yContainerBottomLeft(330.0f)).containerWidth(160.0f)).containerHeight(70.0f)).build();
        component.display();
    }

    protected SummaryChartData(SummaryChartDataBuilder<?, ?> b) {
        super(b);
        this.summaryData = ((SummaryChartDataBuilder)b).summaryData;
    }

    public static SummaryChartDataBuilder<?, ?> builder() {
        return new SummaryChartDataBuilderImpl();
    }

    public SummaryData getSummaryData() {
        return this.summaryData;
    }

    public void setSummaryData(SummaryData summaryData) {
        this.summaryData = summaryData;
    }

    @Override
    public String toString() {
        return "SummaryChartData(summaryData=" + this.getSummaryData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryChartData)) {
            return false;
        }
        SummaryChartData other = (SummaryChartData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SummaryData this$summaryData = this.getSummaryData();
        SummaryData other$summaryData = other.getSummaryData();
        return !(this$summaryData == null ? other$summaryData != null : !((Object)this$summaryData).equals(other$summaryData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SummaryChartData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SummaryData $summaryData = this.getSummaryData();
        result = result * 59 + ($summaryData == null ? 43 : ((Object)$summaryData).hashCode());
        return result;
    }

    public static abstract class SummaryChartDataBuilder<C extends SummaryChartData, B extends SummaryChartDataBuilder<C, B>>
    extends Component.ComponentBuilder<C, B> {
        private SummaryData summaryData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B summaryData(SummaryData summaryData) {
            this.summaryData = summaryData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SummaryChartData.SummaryChartDataBuilder(super=" + super.toString() + ", summaryData=" + this.summaryData + ")";
        }
    }

    private static final class SummaryChartDataBuilderImpl
    extends SummaryChartDataBuilder<SummaryChartData, SummaryChartDataBuilderImpl> {
        private SummaryChartDataBuilderImpl() {
        }

        @Override
        protected SummaryChartDataBuilderImpl self() {
            return this;
        }

        @Override
        public SummaryChartData build() {
            return new SummaryChartData(this);
        }
    }
}

