/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.summary;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.PieStyler;
import tech.grasshopper.pdf.component.chart.ChartComponent;
import tech.grasshopper.pdf.component.chart.ChartDisplayer;
import tech.grasshopper.pdf.component.chart.ReportDonutChart;
import tech.grasshopper.pdf.data.SummaryData;

public class SummaryDonutCharts
extends ChartComponent {
    private SummaryData summaryData;

    @Override
    public void display() {
        this.summaryData = (SummaryData)this.displayData;
        this.createFeatureDonutChart();
        this.createScenarioDonutChart();
        this.createStepDonutChart();
    }

    private void createFeatureDonutChart() {
        Map<String, Number> data = this.createDonutChartDataMap(this.summaryData.getPassedFeatures(), this.summaryData.getFailedFeatures(), this.summaryData.getSkippedFeatures());
        this.createDonutChart(data, 40.0f);
    }

    private void createScenarioDonutChart() {
        Map<String, Number> data = this.createDonutChartDataMap(this.summaryData.getPassedScenarios(), this.summaryData.getFailedScenarios(), this.summaryData.getSkippedScenarios());
        this.createDonutChart(data, 220.0f);
    }

    private void createStepDonutChart() {
        Map<String, Number> data = this.createDonutChartDataMap(this.summaryData.getPassedSteps(), this.summaryData.getFailedSteps(), this.summaryData.getSkippedSteps());
        this.createDonutChart(data, 400.0f);
    }

    private void createDonutChart(Map<String, Number> data, float xOffset) {
        ReportDonutChart chart = new ReportDonutChart(160, 160);
        this.updateChartStyler((PieStyler)chart.getStyler());
        chart.updateData(data);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)chart)).xBottomLeft(xOffset)).yBottomLeft(430.0f)).build()).display();
    }

    private void updateChartStyler(PieStyler styler) {
        styler.setSumFontSize(20.0f);
        styler.setDonutThickness(0.5);
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
    }

    private Map<String, Number> createDonutChartDataMap(Number passed, Number failed, Number skipped) {
        HashMap<String, Number> data = new HashMap<String, Number>();
        data.put("Passed", passed);
        data.put("Failed", failed);
        data.put("Skipped", skipped);
        return data;
    }

    protected SummaryDonutCharts(SummaryDonutChartsBuilder<?, ?> b) {
        super((ChartComponent.ChartComponentBuilder<?, ?>)b);
        this.summaryData = ((SummaryDonutChartsBuilder)b).summaryData;
    }

    public static SummaryDonutChartsBuilder<?, ?> builder() {
        return new SummaryDonutChartsBuilderImpl();
    }

    public SummaryData getSummaryData() {
        return this.summaryData;
    }

    public void setSummaryData(SummaryData summaryData) {
        this.summaryData = summaryData;
    }

    @Override
    public String toString() {
        return "SummaryDonutCharts(summaryData=" + this.getSummaryData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryDonutCharts)) {
            return false;
        }
        SummaryDonutCharts other = (SummaryDonutCharts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SummaryData this$summaryData = this.getSummaryData();
        SummaryData other$summaryData = other.getSummaryData();
        return !(this$summaryData == null ? other$summaryData != null : !((Object)this$summaryData).equals(other$summaryData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SummaryDonutCharts;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SummaryData $summaryData = this.getSummaryData();
        result = result * 59 + ($summaryData == null ? 43 : ((Object)$summaryData).hashCode());
        return result;
    }

    public static abstract class SummaryDonutChartsBuilder<C extends SummaryDonutCharts, B extends SummaryDonutChartsBuilder<C, B>>
    extends ChartComponent.ChartComponentBuilder<C, B> {
        private SummaryData summaryData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B summaryData(SummaryData summaryData) {
            this.summaryData = summaryData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SummaryDonutCharts.SummaryDonutChartsBuilder(super=" + super.toString() + ", summaryData=" + this.summaryData + ")";
        }
    }

    private static final class SummaryDonutChartsBuilderImpl
    extends SummaryDonutChartsBuilder<SummaryDonutCharts, SummaryDonutChartsBuilderImpl> {
        private SummaryDonutChartsBuilderImpl() {
        }

        @Override
        protected SummaryDonutChartsBuilderImpl self() {
            return this;
        }

        @Override
        public SummaryDonutCharts build() {
            return new SummaryDonutCharts(this);
        }
    }
}

