/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.summary;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.component.text.TextComponent;
import tech.grasshopper.pdf.data.SummaryData;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.report.Text;

public class SummaryHeader
extends Component {
    private SummaryData summaryData;
    private static final int TITLE_FONT_SIZE = 16;
    private final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(ReportFont.BOLD_FONT).fontsize(16).spaceWidth(340).build();

    @Override
    public void display() {
        this.summaryData = (SummaryData)this.displayData;
        this.createReportTitleText();
        this.createReportDateText();
    }

    private void createReportTitleText() {
        Text text = Text.builder().textColor(this.reportConfig.getSummaryConfig().titleColor()).font(ReportFont.BOLD_FONT).fontSize(16.0f).xoffset(40.0f).yoffset(750.0f).text(this.featureNameTextOptimizer.optimizeText(this.reportConfig.getSummaryConfig().getTitle())).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    private void createReportDateText() {
        Text text = Text.builder().textColor(this.reportConfig.getSummaryConfig().dateColor()).font(ReportFont.REGULAR_FONT).fontSize(12.0f).xoffset(420.0f).yoffset(750.0f).text(LocalDateTime.now().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM))).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    protected SummaryHeader(SummaryHeaderBuilder<?, ?> b) {
        super(b);
        this.summaryData = ((SummaryHeaderBuilder)b).summaryData;
    }

    public static SummaryHeaderBuilder<?, ?> builder() {
        return new SummaryHeaderBuilderImpl();
    }

    public SummaryData getSummaryData() {
        return this.summaryData;
    }

    public TextLengthOptimizer getFeatureNameTextOptimizer() {
        return this.featureNameTextOptimizer;
    }

    public void setSummaryData(SummaryData summaryData) {
        this.summaryData = summaryData;
    }

    @Override
    public String toString() {
        return "SummaryHeader(summaryData=" + this.getSummaryData() + ", featureNameTextOptimizer=" + this.getFeatureNameTextOptimizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryHeader)) {
            return false;
        }
        SummaryHeader other = (SummaryHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SummaryData this$summaryData = this.getSummaryData();
        SummaryData other$summaryData = other.getSummaryData();
        if (this$summaryData == null ? other$summaryData != null : !((Object)this$summaryData).equals(other$summaryData)) {
            return false;
        }
        TextLengthOptimizer this$featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        TextLengthOptimizer other$featureNameTextOptimizer = other.getFeatureNameTextOptimizer();
        return !(this$featureNameTextOptimizer == null ? other$featureNameTextOptimizer != null : !((Object)this$featureNameTextOptimizer).equals(other$featureNameTextOptimizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SummaryHeader;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SummaryData $summaryData = this.getSummaryData();
        result = result * 59 + ($summaryData == null ? 43 : ((Object)$summaryData).hashCode());
        TextLengthOptimizer $featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        result = result * 59 + ($featureNameTextOptimizer == null ? 43 : ((Object)$featureNameTextOptimizer).hashCode());
        return result;
    }

    public static abstract class SummaryHeaderBuilder<C extends SummaryHeader, B extends SummaryHeaderBuilder<C, B>>
    extends Component.ComponentBuilder<C, B> {
        private SummaryData summaryData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B summaryData(SummaryData summaryData) {
            this.summaryData = summaryData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SummaryHeader.SummaryHeaderBuilder(super=" + super.toString() + ", summaryData=" + this.summaryData + ")";
        }
    }

    private static final class SummaryHeaderBuilderImpl
    extends SummaryHeaderBuilder<SummaryHeader, SummaryHeaderBuilderImpl> {
        private SummaryHeaderBuilderImpl() {
        }

        @Override
        protected SummaryHeaderBuilderImpl self() {
            return this;
        }

        @Override
        public SummaryHeader build() {
            return new SummaryHeader(this);
        }
    }
}

