/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.summary;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import tech.grasshopper.pdf.chapter.page.Page;
import tech.grasshopper.pdf.chapter.summary.SummaryChartData;
import tech.grasshopper.pdf.chapter.summary.SummaryChartTitles;
import tech.grasshopper.pdf.chapter.summary.SummaryDialCharts;
import tech.grasshopper.pdf.chapter.summary.SummaryDonutCharts;
import tech.grasshopper.pdf.chapter.summary.SummaryHeader;
import tech.grasshopper.pdf.chapter.summary.SummaryStatistics;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.exception.PdfReportException;

public class SummaryPage
extends Page
implements DestinationAware {
    private static final Logger logger = Logger.getLogger(SummaryPage.class.getName());
    private PDPage page;

    @Override
    public void createPage() {
        try {
            this.page = new PDPage(PDRectangle.A4);
            this.document.addPage(this.page);
            this.content = new PDPageContentStream(this.document, this.page);
            this.createHeader();
            this.createStatistics();
            this.createChartTitle();
            this.createDonutCharts();
            this.createChartData();
            this.createDialCharts();
            this.createDestination();
            this.content.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }

    private void createHeader() {
        ((SummaryHeader)((SummaryHeader.SummaryHeaderBuilder)((SummaryHeader.SummaryHeaderBuilder)((SummaryHeader.SummaryHeaderBuilder)SummaryHeader.builder().content(this.content)).displayData(this.displayData)).reportConfig(this.reportConfig)).build()).display();
    }

    private void createStatistics() {
        ((SummaryStatistics)((SummaryStatistics.SummaryStatisticsBuilder)((SummaryStatistics.SummaryStatisticsBuilder)((SummaryStatistics.SummaryStatisticsBuilder)SummaryStatistics.builder().content(this.content)).displayData(this.displayData)).reportConfig(this.reportConfig)).build()).display();
    }

    private void createChartTitle() {
        ((SummaryChartTitles)((SummaryChartTitles.SummaryChartTitlesBuilder)((SummaryChartTitles.SummaryChartTitlesBuilder)SummaryChartTitles.builder().content(this.content)).reportConfig(this.reportConfig)).build()).display();
    }

    private void createDonutCharts() {
        ((SummaryDonutCharts)((SummaryDonutCharts.SummaryDonutChartsBuilder)((SummaryDonutCharts.SummaryDonutChartsBuilder)((SummaryDonutCharts.SummaryDonutChartsBuilder)((SummaryDonutCharts.SummaryDonutChartsBuilder)SummaryDonutCharts.builder().document(this.document)).content(this.content)).displayData(this.displayData)).reportConfig(this.reportConfig)).build()).display();
    }

    private void createChartData() {
        ((SummaryChartData)((SummaryChartData.SummaryChartDataBuilder)((SummaryChartData.SummaryChartDataBuilder)((SummaryChartData.SummaryChartDataBuilder)SummaryChartData.builder().content(this.content)).displayData(this.displayData)).reportConfig(this.reportConfig)).build()).display();
    }

    private void createDialCharts() {
        ((SummaryDialCharts)((SummaryDialCharts.SummaryDialChartsBuilder)((SummaryDialCharts.SummaryDialChartsBuilder)((SummaryDialCharts.SummaryDialChartsBuilder)((SummaryDialCharts.SummaryDialChartsBuilder)SummaryDialCharts.builder().document(this.document)).content(this.content)).displayData(this.displayData)).reportConfig(this.reportConfig)).build()).display();
    }

    @Override
    public Destination createDestination() {
        Destination destination = Destination.builder().name("SUMMARY").yCoord(800).page(this.page).build();
        this.destinations.setSummaryChapterDestination(destination);
        return destination;
    }

    protected SummaryPage(SummaryPageBuilder<?, ?> b) {
        super(b);
        this.page = ((SummaryPageBuilder)b).page;
    }

    public static SummaryPageBuilder<?, ?> builder() {
        return new SummaryPageBuilderImpl();
    }

    public PDPage getPage() {
        return this.page;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    @Override
    public String toString() {
        return "SummaryPage(page=" + this.getPage() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryPage)) {
            return false;
        }
        SummaryPage other = (SummaryPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SummaryPage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public static abstract class SummaryPageBuilder<C extends SummaryPage, B extends SummaryPageBuilder<C, B>>
    extends Page.PageBuilder<C, B> {
        private PDPage page;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B page(PDPage page) {
            this.page = page;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SummaryPage.SummaryPageBuilder(super=" + super.toString() + ", page=" + this.page + ")";
        }
    }

    private static final class SummaryPageBuilderImpl
    extends SummaryPageBuilder<SummaryPage, SummaryPageBuilderImpl> {
        private SummaryPageBuilderImpl() {
        }

        @Override
        protected SummaryPageBuilderImpl self() {
            return this;
        }

        @Override
        public SummaryPage build() {
            return new SummaryPage(this);
        }
    }
}

