/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.summary;

import java.awt.Color;
import java.util.ArrayList;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.component.decorator.BackgroundDecorator;
import tech.grasshopper.pdf.component.decorator.BorderDecorator;
import tech.grasshopper.pdf.component.text.MultiLineTextComponent;
import tech.grasshopper.pdf.data.SummaryData;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.pojo.report.Text;
import tech.grasshopper.pdf.util.DateUtil;

public class SummaryStatistics
extends Component {
    private SummaryData summaryData;

    @Override
    public void display() {
        this.summaryData = (SummaryData)this.displayData;
        this.createTestStartedTextBox();
        this.createTestFinishedTextBox();
        this.createTestDurationTextBox();
    }

    private void createTestStartedTextBox() {
        this.createTestStatisticsTextBox("Started At :  " + DateUtil.formatDateWOYear(this.summaryData.getTestRunStartTime()) + ",", DateUtil.formatTimeWithMillis(this.summaryData.getTestRunStartTime()), 50.0f, 40.0f, this.reportConfig.getSummaryConfig().startTimeColor());
    }

    private void createTestFinishedTextBox() {
        this.createTestStatisticsTextBox("Finished At :  " + DateUtil.formatDateWOYear(this.summaryData.getTestRunEndTime()) + ",", DateUtil.formatTimeWithMillis(this.summaryData.getTestRunEndTime()), 230.0f, 220.0f, this.reportConfig.getSummaryConfig().endTimeColor());
    }

    private void createTestDurationTextBox() {
        this.createTestStatisticsTextBox("Duration :", DateUtil.durationValue(this.summaryData.getTestRunDuration()), 410.0f, 400.0f, this.reportConfig.getSummaryConfig().durationColor());
    }

    private void createTestStatisticsTextBox(String topRow, String bottomRow, float xTextOffset, float xBoxOffset, Color valueTextColor) {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().fontSize(13.0f).font(ReportFont.BOLD_ITALIC_FONT).xoffset(xTextOffset).yoffset(705.0f).text(topRow).build());
        texts.add(Text.builder().fontSize(15.0f).textColor(valueTextColor).font(ReportFont.BOLD_ITALIC_FONT).xoffset(xTextOffset).yoffset(685.0f).text(bottomRow).build());
        Component component = ((MultiLineTextComponent.MultiLineTextComponentBuilder)((MultiLineTextComponent.MultiLineTextComponentBuilder)MultiLineTextComponent.builder().content(this.content)).texts(texts)).build();
        component = ((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)BackgroundDecorator.builder().component(component)).content(this.content)).xContainerBottomLeft(xBoxOffset)).yContainerBottomLeft(675.0f)).containerWidth(160.0f)).containerHeight(50.0f)).build();
        component = ((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)BorderDecorator.builder().component(component)).content(this.content)).xContainerBottomLeft(xBoxOffset)).yContainerBottomLeft(675.0f)).containerWidth(160.0f)).containerHeight(50.0f)).build();
        component.display();
    }

    protected SummaryStatistics(SummaryStatisticsBuilder<?, ?> b) {
        super(b);
        this.summaryData = ((SummaryStatisticsBuilder)b).summaryData;
    }

    public static SummaryStatisticsBuilder<?, ?> builder() {
        return new SummaryStatisticsBuilderImpl();
    }

    public SummaryData getSummaryData() {
        return this.summaryData;
    }

    public void setSummaryData(SummaryData summaryData) {
        this.summaryData = summaryData;
    }

    @Override
    public String toString() {
        return "SummaryStatistics(summaryData=" + this.getSummaryData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryStatistics)) {
            return false;
        }
        SummaryStatistics other = (SummaryStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SummaryData this$summaryData = this.getSummaryData();
        SummaryData other$summaryData = other.getSummaryData();
        return !(this$summaryData == null ? other$summaryData != null : !((Object)this$summaryData).equals(other$summaryData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SummaryStatistics;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SummaryData $summaryData = this.getSummaryData();
        result = result * 59 + ($summaryData == null ? 43 : ((Object)$summaryData).hashCode());
        return result;
    }

    public static abstract class SummaryStatisticsBuilder<C extends SummaryStatistics, B extends SummaryStatisticsBuilder<C, B>>
    extends Component.ComponentBuilder<C, B> {
        private SummaryData summaryData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B summaryData(SummaryData summaryData) {
            this.summaryData = summaryData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SummaryStatistics.SummaryStatisticsBuilder(super=" + super.toString() + ", summaryData=" + this.summaryData + ")";
        }
    }

    private static final class SummaryStatisticsBuilderImpl
    extends SummaryStatisticsBuilder<SummaryStatistics, SummaryStatisticsBuilderImpl> {
        private SummaryStatisticsBuilderImpl() {
        }

        @Override
        protected SummaryStatisticsBuilderImpl self() {
            return this;
        }

        @Override
        public SummaryStatistics build() {
            return new SummaryStatistics(this);
        }
    }
}

