/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.component.chart;

import java.awt.Color;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;
import tech.grasshopper.pdf.component.chart.CustomStyler;
import tech.grasshopper.pdf.component.chart.StackedBarChartSeriesData;

public class ReportStackedBarChart
extends CategoryChart
implements CustomStyler,
StackedBarChartSeriesData {
    private Color[] sliceColors = new Color[]{Color.GREEN, Color.RED, Color.ORANGE};

    public ReportStackedBarChart(int width, int height) {
        super(width, height, Styler.ChartTheme.XChart);
        this.updateStyler();
    }

    @Override
    public void updateStyler() {
        CategoryStyler styler = (CategoryStyler)this.getStyler();
        styler.setLegendVisible(false);
        styler.setPlotContentSize(0.95);
        styler.setChartPadding(10);
        styler.setSeriesColors(this.sliceColors);
        styler.setHasAnnotations(false);
        styler.setStacked(true);
        styler.setAvailableSpaceFill(0.4);
        styler.setChartBackgroundColor(Color.WHITE);
    }

    @Override
    public void updateData(int[] xData, int[] passed, int[] failed, int[] skipped) {
        this.addSeries("passed", xData, passed);
        this.addSeries("failed", xData, failed);
        this.addSeries("skipped", xData, skipped);
    }
}

