/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.destination;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;

public class Destination {
    private String name;
    private PDPage page;
    private int xCoord;
    private int yCoord;

    public PDPageXYZDestination createPDPageDestination() {
        PDPageXYZDestination destination = new PDPageXYZDestination();
        destination.setPage(this.page);
        destination.setLeft(this.xCoord);
        destination.setTop(this.yCoord);
        return destination;
    }

    private static int $default$xCoord() {
        return 0;
    }

    private static int $default$yCoord() {
        return 0;
    }

    Destination(String name, PDPage page, int xCoord, int yCoord) {
        this.name = name;
        this.page = page;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
    }

    public static DestinationBuilder builder() {
        return new DestinationBuilder();
    }

    public String getName() {
        return this.name;
    }

    public PDPage getPage() {
        return this.page;
    }

    public int getXCoord() {
        return this.xCoord;
    }

    public int getYCoord() {
        return this.yCoord;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    public void setXCoord(int xCoord) {
        this.xCoord = xCoord;
    }

    public void setYCoord(int yCoord) {
        this.yCoord = yCoord;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        if (this.getXCoord() != other.getXCoord()) {
            return false;
        }
        return this.getYCoord() == other.getYCoord();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Destination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        result = result * 59 + this.getXCoord();
        result = result * 59 + this.getYCoord();
        return result;
    }

    public String toString() {
        return "Destination(name=" + this.getName() + ", page=" + this.getPage() + ", xCoord=" + this.getXCoord() + ", yCoord=" + this.getYCoord() + ")";
    }

    public static class ChapterDestinationStore {
        private Destination summaryChapterDestination;
        private List<Destination> featureChapterDestinations = new ArrayList<Destination>();
        private List<Destination> scenarioChapterDestinations = new ArrayList<Destination>();

        public void addFeatureChapterDestinations(Destination destination) {
            this.featureChapterDestinations.add(destination);
        }

        public void addScenarioChapterDestinations(Destination destination) {
            this.scenarioChapterDestinations.add(destination);
        }

        public Destination getSummaryChapterDestination() {
            return this.summaryChapterDestination;
        }

        public List<Destination> getFeatureChapterDestinations() {
            return this.featureChapterDestinations;
        }

        public List<Destination> getScenarioChapterDestinations() {
            return this.scenarioChapterDestinations;
        }

        public void setSummaryChapterDestination(Destination summaryChapterDestination) {
            this.summaryChapterDestination = summaryChapterDestination;
        }

        public void setFeatureChapterDestinations(List<Destination> featureChapterDestinations) {
            this.featureChapterDestinations = featureChapterDestinations;
        }

        public void setScenarioChapterDestinations(List<Destination> scenarioChapterDestinations) {
            this.scenarioChapterDestinations = scenarioChapterDestinations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChapterDestinationStore)) {
                return false;
            }
            ChapterDestinationStore other = (ChapterDestinationStore)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Destination this$summaryChapterDestination = this.getSummaryChapterDestination();
            Destination other$summaryChapterDestination = other.getSummaryChapterDestination();
            if (this$summaryChapterDestination == null ? other$summaryChapterDestination != null : !((Object)this$summaryChapterDestination).equals(other$summaryChapterDestination)) {
                return false;
            }
            List<Destination> this$featureChapterDestinations = this.getFeatureChapterDestinations();
            List<Destination> other$featureChapterDestinations = other.getFeatureChapterDestinations();
            if (this$featureChapterDestinations == null ? other$featureChapterDestinations != null : !((Object)this$featureChapterDestinations).equals(other$featureChapterDestinations)) {
                return false;
            }
            List<Destination> this$scenarioChapterDestinations = this.getScenarioChapterDestinations();
            List<Destination> other$scenarioChapterDestinations = other.getScenarioChapterDestinations();
            return !(this$scenarioChapterDestinations == null ? other$scenarioChapterDestinations != null : !((Object)this$scenarioChapterDestinations).equals(other$scenarioChapterDestinations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChapterDestinationStore;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Destination $summaryChapterDestination = this.getSummaryChapterDestination();
            result = result * 59 + ($summaryChapterDestination == null ? 43 : ((Object)$summaryChapterDestination).hashCode());
            List<Destination> $featureChapterDestinations = this.getFeatureChapterDestinations();
            result = result * 59 + ($featureChapterDestinations == null ? 43 : ((Object)$featureChapterDestinations).hashCode());
            List<Destination> $scenarioChapterDestinations = this.getScenarioChapterDestinations();
            result = result * 59 + ($scenarioChapterDestinations == null ? 43 : ((Object)$scenarioChapterDestinations).hashCode());
            return result;
        }

        public String toString() {
            return "Destination.ChapterDestinationStore(summaryChapterDestination=" + this.getSummaryChapterDestination() + ", featureChapterDestinations=" + this.getFeatureChapterDestinations() + ", scenarioChapterDestinations=" + this.getScenarioChapterDestinations() + ")";
        }
    }

    public static class DestinationBuilder {
        private String name;
        private PDPage page;
        private int xCoord;
        private boolean xCoord$set;
        private int yCoord;
        private boolean yCoord$set;

        DestinationBuilder() {
        }

        public DestinationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DestinationBuilder page(PDPage page) {
            this.page = page;
            return this;
        }

        public DestinationBuilder xCoord(int xCoord) {
            this.xCoord = xCoord;
            this.xCoord$set = true;
            return this;
        }

        public DestinationBuilder yCoord(int yCoord) {
            this.yCoord = yCoord;
            this.yCoord$set = true;
            return this;
        }

        public Destination build() {
            return new Destination(this.name, this.page, this.xCoord$set ? this.xCoord : Destination.$default$xCoord(), this.yCoord$set ? this.yCoord : Destination.$default$yCoord());
        }

        public String toString() {
            return "Destination.DestinationBuilder(name=" + this.name + ", page=" + this.page + ", xCoord=" + this.xCoord + ", yCoord=" + this.yCoord + ")";
        }
    }
}

