/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.pojo.cucumber;

import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.pojo.cucumber.TimeDetails;
import tech.grasshopper.pdf.section.details.ExecutableDisplay;
import tech.grasshopper.pdf.section.details.HookDisplay;

public class Hook
extends TimeDetails
implements Executable {
    private List<String> output;
    private List<String> media;
    private Status status;
    private String errorMessage;
    private String location;
    private HookType hookType;

    @Override
    public ExecutableDisplay getDisplay() {
        return ((HookDisplay.HookDisplayBuilder)HookDisplay.builder().executable(this)).build();
    }

    @Override
    String getName() {
        return this.location;
    }

    @Override
    public void checkData() {
        if (this.location == null || this.location.isEmpty()) {
            throw new PdfReportException("Location is null or empty for hook - " + this.getName());
        }
        if (this.status == null) {
            throw new PdfReportException("No status present for hook - " + this.getName());
        }
        this.checkTimeData();
    }

    private static List<String> $default$output() {
        return new ArrayList<String>();
    }

    private static List<String> $default$media() {
        return new ArrayList<String>();
    }

    private static String $default$errorMessage() {
        return "";
    }

    private static String $default$location() {
        return "";
    }

    protected Hook(HookBuilder<?, ?> b) {
        super(b);
        this.output = ((HookBuilder)b).output$set ? ((HookBuilder)b).output : Hook.$default$output();
        this.media = ((HookBuilder)b).media$set ? ((HookBuilder)b).media : Hook.$default$media();
        this.status = ((HookBuilder)b).status;
        this.errorMessage = ((HookBuilder)b).errorMessage$set ? ((HookBuilder)b).errorMessage : Hook.$default$errorMessage();
        this.location = ((HookBuilder)b).location$set ? ((HookBuilder)b).location : Hook.$default$location();
        this.hookType = ((HookBuilder)b).hookType;
    }

    public static HookBuilder<?, ?> builder() {
        return new HookBuilderImpl();
    }

    @Override
    public List<String> getOutput() {
        return this.output;
    }

    @Override
    public List<String> getMedia() {
        return this.media;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getLocation() {
        return this.location;
    }

    public HookType getHookType() {
        return this.hookType;
    }

    public void setOutput(List<String> output) {
        this.output = output;
    }

    public void setMedia(List<String> media) {
        this.media = media;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setHookType(HookType hookType) {
        this.hookType = hookType;
    }

    @Override
    public String toString() {
        return "Hook(output=" + this.getOutput() + ", media=" + this.getMedia() + ", status=" + (Object)((Object)this.getStatus()) + ", errorMessage=" + this.getErrorMessage() + ", location=" + this.getLocation() + ", hookType=" + (Object)((Object)this.getHookType()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hook)) {
            return false;
        }
        Hook other = (Hook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$output = this.getOutput();
        List<String> other$output = other.getOutput();
        if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
            return false;
        }
        List<String> this$media = this.getMedia();
        List<String> other$media = other.getMedia();
        if (this$media == null ? other$media != null : !((Object)this$media).equals(other$media)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        HookType this$hookType = this.getHookType();
        HookType other$hookType = other.getHookType();
        return !(this$hookType == null ? other$hookType != null : !((Object)((Object)this$hookType)).equals((Object)other$hookType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Hook;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        List<String> $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : ((Object)$media).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        HookType $hookType = this.getHookType();
        result = result * 59 + ($hookType == null ? 43 : ((Object)((Object)$hookType)).hashCode());
        return result;
    }

    public static abstract class HookBuilder<C extends Hook, B extends HookBuilder<C, B>>
    extends TimeDetails.TimeDetailsBuilder<C, B> {
        private List<String> output;
        private boolean output$set;
        private List<String> media;
        private boolean media$set;
        private Status status;
        private String errorMessage;
        private boolean errorMessage$set;
        private String location;
        private boolean location$set;
        private HookType hookType;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B output(List<String> output) {
            this.output = output;
            this.output$set = true;
            return (B)this.self();
        }

        public B media(List<String> media) {
            this.media = media;
            this.media$set = true;
            return (B)this.self();
        }

        public B status(Status status) {
            this.status = status;
            return (B)this.self();
        }

        public B errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.errorMessage$set = true;
            return (B)this.self();
        }

        public B location(String location) {
            this.location = location;
            this.location$set = true;
            return (B)this.self();
        }

        public B hookType(HookType hookType) {
            this.hookType = hookType;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Hook.HookBuilder(super=" + super.toString() + ", output=" + this.output + ", media=" + this.media + ", status=" + (Object)((Object)this.status) + ", errorMessage=" + this.errorMessage + ", location=" + this.location + ", hookType=" + (Object)((Object)this.hookType) + ")";
        }
    }

    private static final class HookBuilderImpl
    extends HookBuilder<Hook, HookBuilderImpl> {
        private HookBuilderImpl() {
        }

        @Override
        protected HookBuilderImpl self() {
            return this;
        }

        @Override
        public Hook build() {
            return new Hook(this);
        }
    }

    public static enum HookType {
        BEFORE,
        AFTER,
        BEFORE_STEP,
        AFTER_STEP;

    }
}

