/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.pojo.cucumber;

import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Hook;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.pojo.cucumber.TimeDetails;

public class Scenario
extends TimeDetails {
    private String name;
    private Feature feature;
    private List<Hook> before;
    private List<Step> steps;
    private List<Hook> after;
    private List<String> tags;
    private List<Annotation> annotations;
    private Destination destination;
    private int passedSteps;
    private int failedSteps;
    private int skippedSteps;
    private int totalSteps;
    private Status status;

    public List<Hook> getBeforeAfterHooks() {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        hooks.addAll(this.before);
        hooks.addAll(this.after);
        return hooks;
    }

    public List<Executable> getStepsAndHooks() {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        this.before.forEach(h -> {
            boolean bl = executables.add((Executable)h);
        });
        this.steps.forEach(s -> {
            s.getBefore().forEach(h -> {
                boolean bl = executables.add((Executable)h);
            });
            executables.add((Executable)s);
            s.getAfter().forEach(h -> {
                boolean bl = executables.add((Executable)h);
            });
        });
        this.after.forEach(h -> {
            boolean bl = executables.add((Executable)h);
        });
        return executables;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public void checkData() {
        if (this.name == null || this.name.isEmpty()) {
            throw new PdfReportException("Scenario name is null or empty.");
        }
        if (this.feature == null) {
            throw new PdfReportException("No feature present for scenario - " + this.getName());
        }
        if (this.steps == null || this.steps.isEmpty()) {
            throw new PdfReportException("No steps present for scenario - " + this.getName());
        }
        if (this.status == null) {
            throw new PdfReportException("No status present for scenario - " + this.getName());
        }
        this.checkTimeData();
    }

    private static List<Hook> $default$before() {
        return new ArrayList<Hook>();
    }

    private static List<Step> $default$steps() {
        return new ArrayList<Step>();
    }

    private static List<Hook> $default$after() {
        return new ArrayList<Hook>();
    }

    private static List<String> $default$tags() {
        return new ArrayList<String>();
    }

    private static List<Annotation> $default$annotations() {
        return new ArrayList<Annotation>();
    }

    private static int $default$passedSteps() {
        return 0;
    }

    private static int $default$failedSteps() {
        return 0;
    }

    private static int $default$skippedSteps() {
        return 0;
    }

    private static int $default$totalSteps() {
        return 0;
    }

    protected Scenario(ScenarioBuilder<?, ?> b) {
        super(b);
        this.name = ((ScenarioBuilder)b).name;
        this.feature = ((ScenarioBuilder)b).feature;
        this.before = ((ScenarioBuilder)b).before$set ? ((ScenarioBuilder)b).before : Scenario.$default$before();
        this.steps = ((ScenarioBuilder)b).steps$set ? ((ScenarioBuilder)b).steps : Scenario.$default$steps();
        this.after = ((ScenarioBuilder)b).after$set ? ((ScenarioBuilder)b).after : Scenario.$default$after();
        this.tags = ((ScenarioBuilder)b).tags$set ? ((ScenarioBuilder)b).tags : Scenario.$default$tags();
        this.annotations = ((ScenarioBuilder)b).annotations$set ? ((ScenarioBuilder)b).annotations : Scenario.$default$annotations();
        this.destination = ((ScenarioBuilder)b).destination;
        this.passedSteps = ((ScenarioBuilder)b).passedSteps$set ? ((ScenarioBuilder)b).passedSteps : Scenario.$default$passedSteps();
        this.failedSteps = ((ScenarioBuilder)b).failedSteps$set ? ((ScenarioBuilder)b).failedSteps : Scenario.$default$failedSteps();
        this.skippedSteps = ((ScenarioBuilder)b).skippedSteps$set ? ((ScenarioBuilder)b).skippedSteps : Scenario.$default$skippedSteps();
        this.totalSteps = ((ScenarioBuilder)b).totalSteps$set ? ((ScenarioBuilder)b).totalSteps : Scenario.$default$totalSteps();
        this.status = ((ScenarioBuilder)b).status;
    }

    public static ScenarioBuilder<?, ?> builder() {
        return new ScenarioBuilderImpl();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public List<Hook> getBefore() {
        return this.before;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<Hook> getAfter() {
        return this.after;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public int getPassedSteps() {
        return this.passedSteps;
    }

    public int getFailedSteps() {
        return this.failedSteps;
    }

    public int getSkippedSteps() {
        return this.skippedSteps;
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public void setBefore(List<Hook> before) {
        this.before = before;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public void setAfter(List<Hook> after) {
        this.after = after;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setPassedSteps(int passedSteps) {
        this.passedSteps = passedSteps;
    }

    public void setFailedSteps(int failedSteps) {
        this.failedSteps = failedSteps;
    }

    public void setSkippedSteps(int skippedSteps) {
        this.skippedSteps = skippedSteps;
    }

    public void setTotalSteps(int totalSteps) {
        this.totalSteps = totalSteps;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "Scenario(name=" + this.getName() + ", feature=" + this.getFeature() + ", before=" + this.getBefore() + ", steps=" + this.getSteps() + ", after=" + this.getAfter() + ", tags=" + this.getTags() + ", annotations=" + this.getAnnotations() + ", destination=" + this.getDestination() + ", passedSteps=" + this.getPassedSteps() + ", failedSteps=" + this.getFailedSteps() + ", skippedSteps=" + this.getSkippedSteps() + ", totalSteps=" + this.getTotalSteps() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scenario)) {
            return false;
        }
        Scenario other = (Scenario)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature)) {
            return false;
        }
        List<Hook> this$before = this.getBefore();
        List<Hook> other$before = other.getBefore();
        if (this$before == null ? other$before != null : !((Object)this$before).equals(other$before)) {
            return false;
        }
        List<Step> this$steps = this.getSteps();
        List<Step> other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        List<Hook> this$after = this.getAfter();
        List<Hook> other$after = other.getAfter();
        if (this$after == null ? other$after != null : !((Object)this$after).equals(other$after)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Annotation> this$annotations = this.getAnnotations();
        List<Annotation> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Destination this$destination = this.getDestination();
        Destination other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        if (this.getPassedSteps() != other.getPassedSteps()) {
            return false;
        }
        if (this.getFailedSteps() != other.getFailedSteps()) {
            return false;
        }
        if (this.getSkippedSteps() != other.getSkippedSteps()) {
            return false;
        }
        if (this.getTotalSteps() != other.getTotalSteps()) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Scenario;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        List<Hook> $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        List<Step> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        List<Hook> $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Annotation> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Destination $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        result = result * 59 + this.getPassedSteps();
        result = result * 59 + this.getFailedSteps();
        result = result * 59 + this.getSkippedSteps();
        result = result * 59 + this.getTotalSteps();
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public static abstract class ScenarioBuilder<C extends Scenario, B extends ScenarioBuilder<C, B>>
    extends TimeDetails.TimeDetailsBuilder<C, B> {
        private String name;
        private Feature feature;
        private List<Hook> before;
        private boolean before$set;
        private List<Step> steps;
        private boolean steps$set;
        private List<Hook> after;
        private boolean after$set;
        private List<String> tags;
        private boolean tags$set;
        private List<Annotation> annotations;
        private boolean annotations$set;
        private Destination destination;
        private int passedSteps;
        private boolean passedSteps$set;
        private int failedSteps;
        private boolean failedSteps$set;
        private int skippedSteps;
        private boolean skippedSteps$set;
        private int totalSteps;
        private boolean totalSteps$set;
        private Status status;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B feature(Feature feature) {
            this.feature = feature;
            return (B)this.self();
        }

        public B before(List<Hook> before) {
            this.before = before;
            this.before$set = true;
            return (B)this.self();
        }

        public B steps(List<Step> steps) {
            this.steps = steps;
            this.steps$set = true;
            return (B)this.self();
        }

        public B after(List<Hook> after) {
            this.after = after;
            this.after$set = true;
            return (B)this.self();
        }

        public B tags(List<String> tags) {
            this.tags = tags;
            this.tags$set = true;
            return (B)this.self();
        }

        public B annotations(List<Annotation> annotations) {
            this.annotations = annotations;
            this.annotations$set = true;
            return (B)this.self();
        }

        public B destination(Destination destination) {
            this.destination = destination;
            return (B)this.self();
        }

        public B passedSteps(int passedSteps) {
            this.passedSteps = passedSteps;
            this.passedSteps$set = true;
            return (B)this.self();
        }

        public B failedSteps(int failedSteps) {
            this.failedSteps = failedSteps;
            this.failedSteps$set = true;
            return (B)this.self();
        }

        public B skippedSteps(int skippedSteps) {
            this.skippedSteps = skippedSteps;
            this.skippedSteps$set = true;
            return (B)this.self();
        }

        public B totalSteps(int totalSteps) {
            this.totalSteps = totalSteps;
            this.totalSteps$set = true;
            return (B)this.self();
        }

        public B status(Status status) {
            this.status = status;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Scenario.ScenarioBuilder(super=" + super.toString() + ", name=" + this.name + ", feature=" + this.feature + ", before=" + this.before + ", steps=" + this.steps + ", after=" + this.after + ", tags=" + this.tags + ", annotations=" + this.annotations + ", destination=" + this.destination + ", passedSteps=" + this.passedSteps + ", failedSteps=" + this.failedSteps + ", skippedSteps=" + this.skippedSteps + ", totalSteps=" + this.totalSteps + ", status=" + (Object)((Object)this.status) + ")";
        }
    }

    private static final class ScenarioBuilderImpl
    extends ScenarioBuilder<Scenario, ScenarioBuilderImpl> {
        private ScenarioBuilderImpl() {
        }

        @Override
        protected ScenarioBuilderImpl self() {
            return this;
        }

        @Override
        public Scenario build() {
            return new Scenario(this);
        }
    }
}

