/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.dashboard;

import java.awt.Color;
import java.util.HashMap;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.PieStyler;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import tech.grasshopper.pdf.chart.ReportDonutChart;
import tech.grasshopper.pdf.data.SummaryData;
import tech.grasshopper.pdf.image.ImageCreator;
import tech.grasshopper.pdf.section.dashboard.DashboardDisplayUtil;
import tech.grasshopper.pdf.structure.Display;

public class DashboardDonutDisplay
extends Display {
    private Table.TableBuilder tableBuilder;
    private final SummaryData summaryData;

    @Override
    public void display() {
        PDImageXObject featuresDonut = this.createDonutChart(this.summaryData.getPassedFeatures(), this.summaryData.getFailedFeatures(), this.summaryData.getSkippedFeatures());
        PDImageXObject scenariosDonut = this.createDonutChart(this.summaryData.getPassedScenarios(), this.summaryData.getFailedScenarios(), this.summaryData.getSkippedScenarios());
        PDImageXObject stepsDonut = this.createDonutChart(this.summaryData.getPassedSteps(), this.summaryData.getFailedSteps(), this.summaryData.getSkippedSteps());
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)ImageCell.builder().image(featuresDonut).build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)ImageCell.builder().image(scenariosDonut).build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)ImageCell.builder().image(stepsDonut).build()).build()).addRow(DashboardDisplayUtil.spacerRow());
    }

    private PDImageXObject createDonutChart(Number passed, Number failed, Number skipped) {
        ReportDonutChart chart = new ReportDonutChart(150, 150);
        this.updateDonutChartStyler((PieStyler)chart.getStyler());
        HashMap<String, Number> data = new HashMap<String, Number>();
        data.put("Passed", passed);
        data.put("Failed", failed);
        data.put("Skipped", skipped);
        chart.updateData(data);
        return ImageCreator.builder().chart((Chart<?, ?>)chart).document(this.document).build().generateChartImageXObject();
    }

    private void updateDonutChartStyler(PieStyler styler) {
        styler.setSumFontSize(20.0f);
        styler.setDonutThickness(0.35);
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
    }

    protected DashboardDonutDisplay(DashboardDonutDisplayBuilder<?, ?> b) {
        super(b);
        this.summaryData = (SummaryData)this.displayData;
        this.tableBuilder = ((DashboardDonutDisplayBuilder)b).tableBuilder;
    }

    public static DashboardDonutDisplayBuilder<?, ?> builder() {
        return new DashboardDonutDisplayBuilderImpl();
    }

    void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public static abstract class DashboardDonutDisplayBuilder<C extends DashboardDonutDisplay, B extends DashboardDonutDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Table.TableBuilder tableBuilder;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DashboardDonutDisplay.DashboardDonutDisplayBuilder(super=" + super.toString() + ", tableBuilder=" + this.tableBuilder + ")";
        }
    }

    private static final class DashboardDonutDisplayBuilderImpl
    extends DashboardDonutDisplayBuilder<DashboardDonutDisplay, DashboardDonutDisplayBuilderImpl> {
        private DashboardDonutDisplayBuilderImpl() {
        }

        @Override
        protected DashboardDonutDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardDonutDisplay build() {
            return new DashboardDonutDisplay(this);
        }
    }
}

