/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details;

import java.awt.Color;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.tablecell.TableWithinTableCell;

public class MediaDisplay {
    private Executable executable;
    private PDDocument document;
    private static final int MAX_MEDIA_COUNT = 5;
    private static final float AVAILABLE_COLUMN_WIDTH = 572.0f;

    public AbstractCell display() {
        List<String> medias = this.executable.getMedia();
        float mediaWidth = 100.0f;
        float mediaHeigth = 100.0f;
        float padding = 2.0f;
        Table.TableBuilder mediaTableBuilder = Table.builder();
        Row.RowBuilder rowBuilder = Row.builder();
        int mediaCount = medias.size() > 5 ? 5 : medias.size();
        int i = 0;
        while (i < mediaCount) {
            mediaTableBuilder.addColumnOfWidth(mediaWidth);
            PDImageXObject image = PDImageXObject.createFromFile((String)medias.get(i), (PDDocument)this.document);
            rowBuilder.add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().image(image).width(mediaWidth)).padding(padding)).maxHeight(mediaHeigth).build());
            ++i;
        }
        if (medias.size() > 5) {
            mediaTableBuilder.addColumnOfWidth(572.0f - 5.0f * mediaWidth);
            rowBuilder.add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().font(ReportFont.REGULAR_FONT)).fontSize(Integer.valueOf(9))).textColor(Color.RED)).text("Only first 5 medias are displayed.").build());
        }
        mediaTableBuilder.addRow(rowBuilder.build());
        return ((TableWithinTableCell.TableWithinTableCellBuilder)((Object)TableWithinTableCell.builder().table(mediaTableBuilder.build()))).build();
    }

    MediaDisplay(Executable executable, PDDocument document) {
        this.executable = executable;
        this.document = document;
    }

    public static MediaDisplayBuilder builder() {
        return new MediaDisplayBuilder();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaDisplay)) {
            return false;
        }
        MediaDisplay other = (MediaDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Executable this$executable = this.getExecutable();
        Executable other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !this$executable.equals(other$executable)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MediaDisplay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Executable $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : $executable.hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }

    public String toString() {
        return "MediaDisplay(executable=" + this.getExecutable() + ", document=" + this.getDocument() + ")";
    }

    public static class MediaDisplayBuilder {
        private Executable executable;
        private PDDocument document;

        MediaDisplayBuilder() {
        }

        public MediaDisplayBuilder executable(Executable executable) {
            this.executable = executable;
            return this;
        }

        public MediaDisplayBuilder document(PDDocument document) {
            this.document = document;
            return this;
        }

        public MediaDisplay build() {
            return new MediaDisplay(this.executable, this.document);
        }

        public String toString() {
            return "MediaDisplay.MediaDisplayBuilder(executable=" + this.executable + ", document=" + this.document + ")";
        }
    }
}

