/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.pojo.cucumber.Status;

public abstract class Display {
    public static final float CONTENT_START_X = 40.0f;
    public static final float CONTENT_START_Y = 550.0f;
    public static final float CONTENT_END_Y = 40.0f;
    public static final float DETAILED_CONTENT_END_Y = 20.0f;
    public static final float CONTENT_MARGIN_TOP_Y = 40.0f;
    public static final float HEADER_START_Y = 570.0f;
    public static final float HEADER_SECTION_DETAILS_START_X = 50.0f;
    public static final float HEADER_PAGE_NUMBER_START_X = 750.0f;
    public static final float TRIMMED_MESSAGE_START_Y = 20.0f;
    protected PDPageContentStream content;
    protected ReportConfig reportConfig;
    protected PDDocument document;
    protected PDPage page;
    protected DisplayData displayData;
    protected Destination.DestinationStore destinations;
    protected float ylocation;
    protected float xlocation;

    public abstract void display();

    public Color statusColor(Status status) {
        Color color = Color.BLACK;
        if (status == Status.PASSED) {
            color = this.reportConfig.passedColor();
        }
        if (status == Status.FAILED) {
            color = this.reportConfig.failedColor();
        }
        if (status == Status.SKIPPED) {
            color = this.reportConfig.skippedColor();
        }
        return color;
    }

    private static float $default$xlocation() {
        return 40.0f;
    }

    protected Display(DisplayBuilder<?, ?> b) {
        this.content = ((DisplayBuilder)b).content;
        this.reportConfig = ((DisplayBuilder)b).reportConfig;
        this.document = ((DisplayBuilder)b).document;
        this.page = ((DisplayBuilder)b).page;
        this.displayData = ((DisplayBuilder)b).displayData;
        this.destinations = ((DisplayBuilder)b).destinations;
        this.ylocation = ((DisplayBuilder)b).ylocation;
        this.xlocation = ((DisplayBuilder)b).xlocation$set ? ((DisplayBuilder)b).xlocation : Display.$default$xlocation();
    }

    public PDPageContentStream getContent() {
        return this.content;
    }

    public ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public PDPage getPage() {
        return this.page;
    }

    public DisplayData getDisplayData() {
        return this.displayData;
    }

    public Destination.DestinationStore getDestinations() {
        return this.destinations;
    }

    public float getYlocation() {
        return this.ylocation;
    }

    public float getXlocation() {
        return this.xlocation;
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setReportConfig(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    public void setDisplayData(DisplayData displayData) {
        this.displayData = displayData;
    }

    public void setDestinations(Destination.DestinationStore destinations) {
        this.destinations = destinations;
    }

    public void setYlocation(float ylocation) {
        this.ylocation = ylocation;
    }

    public void setXlocation(float xlocation) {
        this.xlocation = xlocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Display)) {
            return false;
        }
        Display other = (Display)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDPageContentStream this$content = this.getContent();
        PDPageContentStream other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        ReportConfig this$reportConfig = this.getReportConfig();
        ReportConfig other$reportConfig = other.getReportConfig();
        if (this$reportConfig == null ? other$reportConfig != null : !((Object)this$reportConfig).equals(other$reportConfig)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        DisplayData this$displayData = this.getDisplayData();
        DisplayData other$displayData = other.getDisplayData();
        if (this$displayData == null ? other$displayData != null : !this$displayData.equals(other$displayData)) {
            return false;
        }
        Destination.DestinationStore this$destinations = this.getDestinations();
        Destination.DestinationStore other$destinations = other.getDestinations();
        if (this$destinations == null ? other$destinations != null : !((Object)this$destinations).equals(other$destinations)) {
            return false;
        }
        if (Float.compare(this.getYlocation(), other.getYlocation()) != 0) {
            return false;
        }
        return Float.compare(this.getXlocation(), other.getXlocation()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Display;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDPageContentStream $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        ReportConfig $reportConfig = this.getReportConfig();
        result = result * 59 + ($reportConfig == null ? 43 : ((Object)$reportConfig).hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        DisplayData $displayData = this.getDisplayData();
        result = result * 59 + ($displayData == null ? 43 : $displayData.hashCode());
        Destination.DestinationStore $destinations = this.getDestinations();
        result = result * 59 + ($destinations == null ? 43 : ((Object)$destinations).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getYlocation());
        result = result * 59 + Float.floatToIntBits(this.getXlocation());
        return result;
    }

    public String toString() {
        return "Display(content=" + this.getContent() + ", reportConfig=" + this.getReportConfig() + ", document=" + this.getDocument() + ", page=" + this.getPage() + ", displayData=" + this.getDisplayData() + ", destinations=" + this.getDestinations() + ", ylocation=" + this.getYlocation() + ", xlocation=" + this.getXlocation() + ")";
    }

    public static abstract class DisplayBuilder<C extends Display, B extends DisplayBuilder<C, B>> {
        private PDPageContentStream content;
        private ReportConfig reportConfig;
        private PDDocument document;
        private PDPage page;
        private DisplayData displayData;
        private Destination.DestinationStore destinations;
        private float ylocation;
        private float xlocation;
        private boolean xlocation$set;

        protected abstract B self();

        public abstract C build();

        public B content(PDPageContentStream content) {
            this.content = content;
            return this.self();
        }

        public B reportConfig(ReportConfig reportConfig) {
            this.reportConfig = reportConfig;
            return this.self();
        }

        public B document(PDDocument document) {
            this.document = document;
            return this.self();
        }

        public B page(PDPage page) {
            this.page = page;
            return this.self();
        }

        public B displayData(DisplayData displayData) {
            this.displayData = displayData;
            return this.self();
        }

        public B destinations(Destination.DestinationStore destinations) {
            this.destinations = destinations;
            return this.self();
        }

        public B ylocation(float ylocation) {
            this.ylocation = ylocation;
            return this.self();
        }

        public B xlocation(float xlocation) {
            this.xlocation = xlocation;
            this.xlocation$set = true;
            return this.self();
        }

        public String toString() {
            return "Display.DisplayBuilder(content=" + this.content + ", reportConfig=" + this.reportConfig + ", document=" + this.document + ", page=" + this.page + ", displayData=" + this.displayData + ", destinations=" + this.destinations + ", ylocation=" + this.ylocation + ", xlocation=" + this.xlocation + ")";
        }
    }
}

