/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.annotation;

import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;

public class Annotation {
    private String title;
    private float xBottom;
    private float yBottom;
    private float width;
    private float height;
    private PDPage page;

    public PDAnnotationLink createPDAnnotationLink() {
        PDRectangle position = new PDRectangle(this.xBottom, this.yBottom, this.width, this.height);
        PDAnnotationLink link = new PDAnnotationLink();
        PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
        link.setBorderStyle(borderULine);
        link.setRectangle(position);
        return link;
    }

    public static void updateDestination(ReportData reportData) {
        for (Feature feature : reportData.getFeatures()) {
            feature.getAnnotations().forEach(a -> Annotation.updateDestination(a, feature.getDestination()));
            for (Scenario scenario : feature.getScenarios()) {
                scenario.getAnnotations().forEach(a -> Annotation.updateDestination(a, scenario.getDestination()));
            }
        }
    }

    private static void updateDestination(Annotation annotation, Destination destination) {
        PDActionGoTo action = new PDActionGoTo();
        action.setDestination((PDDestination)destination.createPDPageDestination());
        PDAnnotationLink link = annotation.createPDAnnotationLink();
        link.setAction((PDAction)action);
        annotation.getPage().getAnnotations().add(link);
    }

    Annotation(String title, float xBottom, float yBottom, float width, float height, PDPage page) {
        this.title = title;
        this.xBottom = xBottom;
        this.yBottom = yBottom;
        this.width = width;
        this.height = height;
        this.page = page;
    }

    public static AnnotationBuilder builder() {
        return new AnnotationBuilder();
    }

    public PDPage getPage() {
        return this.page;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setXBottom(float xBottom) {
        this.xBottom = xBottom;
    }

    public void setYBottom(float yBottom) {
        this.yBottom = yBottom;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    public static class AnnotationBuilder {
        private String title;
        private float xBottom;
        private float yBottom;
        private float width;
        private float height;
        private PDPage page;

        AnnotationBuilder() {
        }

        public AnnotationBuilder title(String title) {
            this.title = title;
            return this;
        }

        public AnnotationBuilder xBottom(float xBottom) {
            this.xBottom = xBottom;
            return this;
        }

        public AnnotationBuilder yBottom(float yBottom) {
            this.yBottom = yBottom;
            return this;
        }

        public AnnotationBuilder width(float width) {
            this.width = width;
            return this;
        }

        public AnnotationBuilder height(float height) {
            this.height = height;
            return this;
        }

        public AnnotationBuilder page(PDPage page) {
            this.page = page;
            return this;
        }

        public Annotation build() {
            return new Annotation(this.title, this.xBottom, this.yBottom, this.width, this.height, this.page);
        }

        public String toString() {
            return "Annotation.AnnotationBuilder(title=" + this.title + ", xBottom=" + this.xBottom + ", yBottom=" + this.yBottom + ", width=" + this.width + ", height=" + this.height + ", page=" + this.page + ")";
        }
    }
}

