/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.data;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.data.SummaryData;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.pojo.cucumber.TimeDetails;

public class ReportData {
    private List<Feature> features;
    private SummaryData summaryData;
    private FeatureData featureData;
    private ScenarioData scenarioData;

    public void checkData() {
        if (this.features == null || this.features.size() == 0) {
            throw new PdfReportException("No features present in test execution.");
        }
        for (Feature feature : this.features) {
            feature.checkData();
            for (Scenario scenario : feature.getScenarios()) {
                scenario.checkData();
                for (Executable executable : scenario.getStepsAndHooks()) {
                    executable.checkData();
                }
            }
        }
    }

    public void populateSectionData() {
        this.populateCounts();
        this.populateDashboardData();
        this.populateFeaturesData();
        this.populateScenariosData();
    }

    private void populateCounts() {
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                for (Step step : scenario.getSteps()) {
                    if (step.getStatus() == Status.PASSED) {
                        scenario.setPassedSteps(scenario.getPassedSteps() + 1);
                        feature.setPassedSteps(feature.getPassedSteps() + 1);
                    } else if (step.getStatus() == Status.FAILED) {
                        scenario.setFailedSteps(scenario.getFailedSteps() + 1);
                        feature.setFailedSteps(feature.getFailedSteps() + 1);
                    } else {
                        scenario.setSkippedSteps(scenario.getSkippedSteps() + 1);
                        feature.setSkippedSteps(feature.getSkippedSteps() + 1);
                    }
                    scenario.setTotalSteps(scenario.getTotalSteps() + 1);
                    feature.setTotalSteps(feature.getTotalSteps() + 1);
                }
                if (scenario.getStatus() == Status.PASSED) {
                    feature.setPassedScenarios(feature.getPassedScenarios() + 1);
                } else if (scenario.getStatus() == Status.FAILED) {
                    feature.setFailedScenarios(feature.getFailedScenarios() + 1);
                } else {
                    feature.setSkippedScenarios(feature.getSkippedScenarios() + 1);
                }
                feature.setTotalScenarios(feature.getTotalScenarios() + 1);
            }
        }
    }

    private void populateDashboardData() {
        this.summaryData = SummaryData.builder().testRunStartTime((LocalDateTime)Collections.min(this.features.stream().map(TimeDetails::getStartTime).collect(Collectors.toList()))).testRunEndTime((LocalDateTime)Collections.max(this.features.stream().map(TimeDetails::getEndTime).collect(Collectors.toList()))).build();
        for (Feature feature : this.features) {
            if (feature.getStatus() == Status.PASSED) {
                this.summaryData.setPassedFeatures(this.summaryData.getPassedFeatures() + 1);
            } else if (feature.getStatus() == Status.FAILED) {
                this.summaryData.setFailedFeatures(this.summaryData.getFailedFeatures() + 1);
            } else {
                this.summaryData.setSkippedFeatures(this.summaryData.getSkippedFeatures() + 1);
            }
            this.summaryData.setTotalFeatures(this.summaryData.getTotalFeatures() + 1);
            this.summaryData.setPassedScenarios(this.summaryData.getPassedScenarios() + feature.getPassedScenarios());
            this.summaryData.setFailedScenarios(this.summaryData.getFailedScenarios() + feature.getFailedScenarios());
            this.summaryData.setSkippedScenarios(this.summaryData.getSkippedScenarios() + feature.getSkippedScenarios());
            this.summaryData.setTotalScenarios(this.summaryData.getTotalScenarios() + feature.getTotalScenarios());
            this.summaryData.setPassedSteps(this.summaryData.getPassedSteps() + feature.getPassedSteps());
            this.summaryData.setFailedSteps(this.summaryData.getFailedSteps() + feature.getFailedSteps());
            this.summaryData.setSkippedSteps(this.summaryData.getSkippedSteps() + feature.getSkippedSteps());
            this.summaryData.setTotalSteps(this.summaryData.getTotalSteps() + feature.getTotalSteps());
        }
    }

    private void populateFeaturesData() {
        this.featureData = FeatureData.builder().features(this.features).build();
    }

    private void populateScenariosData() {
        this.scenarioData = ScenarioData.builder().build();
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                scenario.setFeature(feature);
                this.scenarioData.getScenarios().add(scenario);
            }
        }
    }

    ReportData(List<Feature> features, SummaryData summaryData, FeatureData featureData, ScenarioData scenarioData) {
        this.features = features;
        this.summaryData = summaryData;
        this.featureData = featureData;
        this.scenarioData = scenarioData;
    }

    public static ReportDataBuilder builder() {
        return new ReportDataBuilder();
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public SummaryData getSummaryData() {
        return this.summaryData;
    }

    public FeatureData getFeatureData() {
        return this.featureData;
    }

    public ScenarioData getScenarioData() {
        return this.scenarioData;
    }

    public static class ReportDataBuilder {
        private List<Feature> features;
        private SummaryData summaryData;
        private FeatureData featureData;
        private ScenarioData scenarioData;

        ReportDataBuilder() {
        }

        public ReportDataBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public ReportDataBuilder summaryData(SummaryData summaryData) {
            this.summaryData = summaryData;
            return this;
        }

        public ReportDataBuilder featureData(FeatureData featureData) {
            this.featureData = featureData;
            return this;
        }

        public ReportDataBuilder scenarioData(ScenarioData scenarioData) {
            this.scenarioData = scenarioData;
            return this;
        }

        public ReportData build() {
            return new ReportData(this.features, this.summaryData, this.featureData, this.scenarioData);
        }

        public String toString() {
            return "ReportData.ReportDataBuilder(features=" + this.features + ", summaryData=" + this.summaryData + ", featureData=" + this.featureData + ", scenarioData=" + this.scenarioData + ")";
        }
    }
}

