/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details;

import java.awt.Color;
import java.util.List;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.section.details.DetailedStepHookDisplay;

public class LogMessageDisplay {
    private Executable executable;
    private Color color;
    private final float fontsize = 9.0f;
    private static final int MAX_COUNT_LOGS = 4;
    private static final int MAX_LINES_PER_LOG = 2;

    public AbstractCell display() {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        TextLengthOptimizer textOptimizer = TextLengthOptimizer.builder().font(DetailedStepHookDisplay.STEP_HOOK_TEXT_FONT).fontsize(9).availableSpace(572.0f).maxLines(2).build();
        ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder = ParagraphCell.Paragraph.builder();
        boolean started = true;
        boolean trimLog = false;
        List<String> logs = this.executable.getOutput().size() > 4 ? this.executable.getOutput().subList(0, 4) : this.executable.getOutput();
        for (String log : logs) {
            if (started) {
                started = false;
            } else {
                paragraphBuilder.appendNewLine();
            }
            paragraphBuilder.append(StyledText.builder().font(ReportFont.REGULAR_FONT).fontSize(Float.valueOf(9.0f)).text(sanitizer.sanitizeText(textOptimizer.optimizeTextLines(log))).color(this.color).build());
            if (trimLog || !textOptimizer.isTextTrimmed()) continue;
            trimLog = true;
        }
        String croppedMsgSuffix = " to fit in the available space.";
        String message = "";
        if (trimLog) {
            message = "* Each log length is trimmed to 2 lines";
        }
        if (this.executable.getOutput().size() > 4) {
            String capitalizeText = trimLog ? " and m" : "* M";
            message = String.valueOf(message) + capitalizeText + "aximum of " + 4 + " logs are displayed";
        }
        if (!message.isEmpty()) {
            paragraphBuilder.appendNewLine().append(StyledText.builder().font(ReportFont.REGULAR_FONT).fontSize(Float.valueOf(9.0f)).text(String.valueOf(message) + " to fit in the available space.").color(this.color).build());
        }
        return ParagraphCell.builder().paragraph(paragraphBuilder.build()).lineSpacing(1.1f).build();
    }

    LogMessageDisplay(Executable executable, Color color) {
        this.executable = executable;
        this.color = color;
    }

    public static LogMessageDisplayBuilder builder() {
        return new LogMessageDisplayBuilder();
    }

    public static class LogMessageDisplayBuilder {
        private Executable executable;
        private Color color;

        LogMessageDisplayBuilder() {
        }

        public LogMessageDisplayBuilder executable(Executable executable) {
            this.executable = executable;
            return this;
        }

        public LogMessageDisplayBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public LogMessageDisplay build() {
            return new LogMessageDisplay(this.executable, this.color);
        }

        public String toString() {
            return "LogMessageDisplay.LogMessageDisplayBuilder(executable=" + this.executable + ", color=" + this.color + ")";
        }
    }
}

