/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.util;

import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.util.PdfUtil;

public class TextUtil {
    private PDFont font;
    private int fontSize;
    private String text;
    private float width;
    private float lineSpacing;
    private float padding;

    public float tableRowHeight() {
        float textHeight = PdfUtil.getFontHeight((PDFont)this.font, (int)this.fontSize);
        int size = PdfUtil.getOptimalTextBreakLines((String)this.text, (PDFont)this.font, (int)this.fontSize, (float)(this.width - 2.0f * this.padding)).size();
        float heightOfTextLines = (float)size * textHeight;
        float heightOfLineSpacing = (float)(size - 1) * textHeight * this.lineSpacing;
        return heightOfTextLines + heightOfLineSpacing + 2.0f * this.padding;
    }

    private static float $default$lineSpacing() {
        return 1.0f;
    }

    private static float $default$padding() {
        return 0.0f;
    }

    TextUtil(PDFont font, int fontSize, String text, float width, float lineSpacing, float padding) {
        this.font = font;
        this.fontSize = fontSize;
        this.text = text;
        this.width = width;
        this.lineSpacing = lineSpacing;
        this.padding = padding;
    }

    public static TextUtilBuilder builder() {
        return new TextUtilBuilder();
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public static class TextUtilBuilder {
        private PDFont font;
        private int fontSize;
        private String text;
        private float width;
        private float lineSpacing;
        private boolean lineSpacing$set;
        private float padding;
        private boolean padding$set;

        TextUtilBuilder() {
        }

        public TextUtilBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public TextUtilBuilder fontSize(int fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public TextUtilBuilder text(String text) {
            this.text = text;
            return this;
        }

        public TextUtilBuilder width(float width) {
            this.width = width;
            return this;
        }

        public TextUtilBuilder lineSpacing(float lineSpacing) {
            this.lineSpacing = lineSpacing;
            this.lineSpacing$set = true;
            return this;
        }

        public TextUtilBuilder padding(float padding) {
            this.padding = padding;
            this.padding$set = true;
            return this;
        }

        public TextUtil build() {
            return new TextUtil(this.font, this.fontSize, this.text, this.width, this.lineSpacing$set ? this.lineSpacing : TextUtil.$default$lineSpacing(), this.padding$set ? this.padding : TextUtil.$default$padding());
        }

        public String toString() {
            return "TextUtil.TextUtilBuilder(font=" + this.font + ", fontSize=" + this.fontSize + ", text=" + this.text + ", width=" + this.width + ", lineSpacing=" + this.lineSpacing + ", padding=" + this.padding + ")";
        }
    }
}

