/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.pojo.cucumber;

import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.config.StepHookFilter;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Hook;
import tech.grasshopper.pdf.pojo.cucumber.NonExecutable;
import tech.grasshopper.pdf.pojo.cucumber.Step;

public class Scenario
extends NonExecutable {
    private Feature feature;
    private List<Hook> before;
    private List<Step> steps;
    private List<Hook> after;
    private List<String> tags;
    private int passedSteps;
    private int failedSteps;
    private int skippedSteps;
    private int totalSteps;

    public List<Hook> getBeforeAfterHooks() {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        hooks.addAll(this.before);
        hooks.addAll(this.after);
        return hooks;
    }

    public List<Executable> getStepsAndHooks() {
        return StepHookFilter.allExecutables(this.steps, this.before, this.after);
    }

    public List<Executable> getFilteredStepsAndHooks(ReportConfig reportConfig) {
        return StepHookFilter.filterExecutables(reportConfig, this.steps, this.before, this.after);
    }

    @Override
    public void checkData() {
        if (this.name == null || this.name.isEmpty()) {
            throw new PdfReportException("Scenario name is null or empty.");
        }
        if (this.feature == null) {
            throw new PdfReportException("No feature present for scenario - " + this.getName());
        }
        if (this.steps == null || this.steps.isEmpty()) {
            throw new PdfReportException("No steps present for scenario - " + this.getName());
        }
        if (this.status == null) {
            throw new PdfReportException("No status present for scenario - " + this.getName());
        }
        super.checkData();
    }

    private static List<Hook> $default$before() {
        return new ArrayList<Hook>();
    }

    private static List<Step> $default$steps() {
        return new ArrayList<Step>();
    }

    private static List<Hook> $default$after() {
        return new ArrayList<Hook>();
    }

    private static List<String> $default$tags() {
        return new ArrayList<String>();
    }

    private static int $default$passedSteps() {
        return 0;
    }

    private static int $default$failedSteps() {
        return 0;
    }

    private static int $default$skippedSteps() {
        return 0;
    }

    private static int $default$totalSteps() {
        return 0;
    }

    protected Scenario(ScenarioBuilder<?, ?> b) {
        super((NonExecutable.NonExecutableBuilder<?, ?>)b);
        this.feature = ((ScenarioBuilder)b).feature;
        this.before = ((ScenarioBuilder)b).before$set ? ((ScenarioBuilder)b).before$value : Scenario.$default$before();
        this.steps = ((ScenarioBuilder)b).steps$set ? ((ScenarioBuilder)b).steps$value : Scenario.$default$steps();
        this.after = ((ScenarioBuilder)b).after$set ? ((ScenarioBuilder)b).after$value : Scenario.$default$after();
        this.tags = ((ScenarioBuilder)b).tags$set ? ((ScenarioBuilder)b).tags$value : Scenario.$default$tags();
        this.passedSteps = ((ScenarioBuilder)b).passedSteps$set ? ((ScenarioBuilder)b).passedSteps$value : Scenario.$default$passedSteps();
        this.failedSteps = ((ScenarioBuilder)b).failedSteps$set ? ((ScenarioBuilder)b).failedSteps$value : Scenario.$default$failedSteps();
        this.skippedSteps = ((ScenarioBuilder)b).skippedSteps$set ? ((ScenarioBuilder)b).skippedSteps$value : Scenario.$default$skippedSteps();
        this.totalSteps = ((ScenarioBuilder)b).totalSteps$set ? ((ScenarioBuilder)b).totalSteps$value : Scenario.$default$totalSteps();
    }

    public static ScenarioBuilder<?, ?> builder() {
        return new ScenarioBuilderImpl();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public List<Hook> getBefore() {
        return this.before;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<Hook> getAfter() {
        return this.after;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    public int getPassedSteps() {
        return this.passedSteps;
    }

    public int getFailedSteps() {
        return this.failedSteps;
    }

    public int getSkippedSteps() {
        return this.skippedSteps;
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public void setBefore(List<Hook> before) {
        this.before = before;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public void setAfter(List<Hook> after) {
        this.after = after;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setPassedSteps(int passedSteps) {
        this.passedSteps = passedSteps;
    }

    public void setFailedSteps(int failedSteps) {
        this.failedSteps = failedSteps;
    }

    public void setSkippedSteps(int skippedSteps) {
        this.skippedSteps = skippedSteps;
    }

    public void setTotalSteps(int totalSteps) {
        this.totalSteps = totalSteps;
    }

    @Override
    public String toString() {
        return "Scenario(feature=" + this.getFeature() + ", before=" + this.getBefore() + ", steps=" + this.getSteps() + ", after=" + this.getAfter() + ", tags=" + this.getTags() + ", passedSteps=" + this.getPassedSteps() + ", failedSteps=" + this.getFailedSteps() + ", skippedSteps=" + this.getSkippedSteps() + ", totalSteps=" + this.getTotalSteps() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scenario)) {
            return false;
        }
        Scenario other = (Scenario)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPassedSteps() != other.getPassedSteps()) {
            return false;
        }
        if (this.getFailedSteps() != other.getFailedSteps()) {
            return false;
        }
        if (this.getSkippedSteps() != other.getSkippedSteps()) {
            return false;
        }
        if (this.getTotalSteps() != other.getTotalSteps()) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature)) {
            return false;
        }
        List<Hook> this$before = this.getBefore();
        List<Hook> other$before = other.getBefore();
        if (this$before == null ? other$before != null : !((Object)this$before).equals(other$before)) {
            return false;
        }
        List<Step> this$steps = this.getSteps();
        List<Step> other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        List<Hook> this$after = this.getAfter();
        List<Hook> other$after = other.getAfter();
        if (this$after == null ? other$after != null : !((Object)this$after).equals(other$after)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Scenario;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPassedSteps();
        result = result * 59 + this.getFailedSteps();
        result = result * 59 + this.getSkippedSteps();
        result = result * 59 + this.getTotalSteps();
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        List<Hook> $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        List<Step> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        List<Hook> $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    private static final class ScenarioBuilderImpl
    extends ScenarioBuilder<Scenario, ScenarioBuilderImpl> {
        private ScenarioBuilderImpl() {
        }

        @Override
        protected ScenarioBuilderImpl self() {
            return this;
        }

        @Override
        public Scenario build() {
            return new Scenario(this);
        }
    }

    public static abstract class ScenarioBuilder<C extends Scenario, B extends ScenarioBuilder<C, B>>
    extends NonExecutable.NonExecutableBuilder<C, B> {
        private Feature feature;
        private boolean before$set;
        private List<Hook> before$value;
        private boolean steps$set;
        private List<Step> steps$value;
        private boolean after$set;
        private List<Hook> after$value;
        private boolean tags$set;
        private List<String> tags$value;
        private boolean passedSteps$set;
        private int passedSteps$value;
        private boolean failedSteps$set;
        private int failedSteps$value;
        private boolean skippedSteps$set;
        private int skippedSteps$value;
        private boolean totalSteps$set;
        private int totalSteps$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B feature(Feature feature) {
            this.feature = feature;
            return (B)this.self();
        }

        public B before(List<Hook> before) {
            this.before$value = before;
            this.before$set = true;
            return (B)this.self();
        }

        public B steps(List<Step> steps) {
            this.steps$value = steps;
            this.steps$set = true;
            return (B)this.self();
        }

        public B after(List<Hook> after) {
            this.after$value = after;
            this.after$set = true;
            return (B)this.self();
        }

        @Override
        public B tags(List<String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return (B)this.self();
        }

        public B passedSteps(int passedSteps) {
            this.passedSteps$value = passedSteps;
            this.passedSteps$set = true;
            return (B)this.self();
        }

        public B failedSteps(int failedSteps) {
            this.failedSteps$value = failedSteps;
            this.failedSteps$set = true;
            return (B)this.self();
        }

        public B skippedSteps(int skippedSteps) {
            this.skippedSteps$value = skippedSteps;
            this.skippedSteps$set = true;
            return (B)this.self();
        }

        public B totalSteps(int totalSteps) {
            this.totalSteps$value = totalSteps;
            this.totalSteps$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Scenario.ScenarioBuilder(super=" + super.toString() + ", feature=" + this.feature + ", before$value=" + this.before$value + ", steps$value=" + this.steps$value + ", after$value=" + this.after$value + ", tags$value=" + this.tags$value + ", passedSteps$value=" + this.passedSteps$value + ", failedSteps$value=" + this.failedSteps$value + ", skippedSteps$value=" + this.skippedSteps$value + ", totalSteps$value=" + this.totalSteps$value + ")";
        }
    }
}

