/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.expanded;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.TableCreator;
import tech.grasshopper.pdf.structure.cell.TextLinkCell;

public class ExpandedMediaDisplay
extends Display
implements DestinationAware {
    private Executable executable;
    private float finalY;
    private int destinationY;
    private static final float GAP = 10.0f;
    private static final float DATA_COLUMN_WIDTH = 200.0f;
    private static final float IMAGE_COLUMN_WIDTH = 560.0f;
    private static final float PADDING = 5.0f;
    private static final PDFont DATA_FONT = ReportFont.REGULAR_FONT;
    private static final int DATA_FONT_SIZE = 10;
    private final TextSanitizer sanitizer = TextSanitizer.builder().build();
    private final TextLengthOptimizer optimizer = TextLengthOptimizer.builder().font(DATA_FONT).fontsize(10).availableSpace(190.0f).maxLines(4).build();

    @Override
    public void display() {
        PDPage initialPage = this.document.getPage(this.document.getNumberOfPages() - 1);
        for (int i = 0; i < this.executable.getMedia().size(); ++i) {
            this.destinationY = (int)this.ylocation;
            String media = this.executable.getMedia().get(i);
            PDImageXObject image = PDImageXObject.createFromFile((String)media, (PDDocument)this.document);
            Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{200.0f, 560.0f}).borderWidth(1.0f).borderColor(Color.GRAY).padding(5.0f).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP).font(DATA_FONT).fontSize(Integer.valueOf(10)).textColor(Color.DARK_GRAY).addRow(Row.builder().add((AbstractCell)this.stepDetails(this.executable, i)).add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().image(image).maxHeight(240.0f).rowSpan(3)).borderWidth(0.0f)).padding(0.0f)).build()).build()).addRow(Row.builder().add(this.scenarioDetails(this.executable)).build()).addRow(Row.builder().add(this.featureDetails(this.executable)).build());
            Object tableCreator = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(tableBuilder)).document(this.document)).startX(40.0f)).startY(this.ylocation)).endY(40.0f)).repeatRows(1)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageWithHeaderAndNumberSupplier("EXPANDED SECTION"))).build();
            ((TableCreator)tableCreator).displayTable();
            this.page = ((TableCreator)tableCreator).getTableStartPage();
            this.ylocation = ((TableCreator)tableCreator).getFinalY() - 10.0f;
            if (!initialPage.equals((Object)this.page)) {
                this.destinationY = 550;
                initialPage = this.page;
            }
            this.createDestination();
        }
        this.finalY = this.ylocation;
    }

    private ParagraphCell stepDetails(Executable executable, int index) {
        ParagraphCell.Paragraph.ParagraphBuilder detailsBuilder = ParagraphCell.Paragraph.builder();
        if (executable.getMedia().size() > 1) {
            detailsBuilder.append(StyledText.builder().text("Media No : " + (index + 1)).color(this.reportConfig.getDetailedStepHookConfig().stepTextColor()).build());
            detailsBuilder.appendNewLine();
        }
        detailsBuilder.append(StyledText.builder().text(this.optimizer.optimizeTextLines("(Step) " + this.sanitizer.sanitizeText(executable.getDisplay().executableName()))).color(this.reportConfig.getDetailedStepHookConfig().stepTextColor()).build());
        return ParagraphCell.builder().paragraph(detailsBuilder.build()).lineSpacing(1.3f).build();
    }

    private AbstractCell featureDetails(Executable executable) {
        if (this.reportConfig.isDisplayDetailed() && this.reportConfig.isDisplayExpanded()) {
            Annotation featureAnnotation = Annotation.builder().title(this.sanitizer.sanitizeText(executable.getFeature().getName())).build();
            executable.getFeature().addAnnotation(featureAnnotation);
            return ((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().text(this.optimizer.optimizeTextLines("(F) " + this.sanitizer.sanitizeText(executable.getFeature().getName())))).textColor(this.reportConfig.getDetailedFeatureConfig().featureNameColor())).annotation(featureAnnotation).build();
        }
        return ((TextCell.TextCellBuilder)TextCell.builder().text(this.optimizer.optimizeTextLines("(F) " + this.sanitizer.sanitizeText(executable.getFeature().getName()))).textColor(this.reportConfig.getDetailedFeatureConfig().featureNameColor())).build();
    }

    private AbstractCell scenarioDetails(Executable executable) {
        if (this.reportConfig.isDisplayDetailed() && this.reportConfig.isDisplayExpanded()) {
            Annotation scenarioAnnotation = Annotation.builder().title(this.sanitizer.sanitizeText(executable.getScenario().getName())).build();
            executable.getScenario().addAnnotation(scenarioAnnotation);
            return ((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().text(this.optimizer.optimizeTextLines("(S) " + this.sanitizer.sanitizeText(executable.getScenario().getName())))).textColor(this.reportConfig.getDetailedScenarioConfig().scenarioNameColor())).annotation(scenarioAnnotation).build();
        }
        return ((TextCell.TextCellBuilder)TextCell.builder().text(this.optimizer.optimizeTextLines("(S) " + this.sanitizer.sanitizeText(executable.getScenario().getName()))).textColor(this.reportConfig.getDetailedScenarioConfig().scenarioNameColor())).build();
    }

    @Override
    public void createDestination() {
        Destination destination = Destination.builder().yCoord(this.destinationY).page(this.page).build();
        this.executable.getDestinations().add(destination);
    }

    protected ExpandedMediaDisplay(ExpandedMediaDisplayBuilder<?, ?> b) {
        super(b);
        this.executable = ((ExpandedMediaDisplayBuilder)b).executable;
        this.finalY = ((ExpandedMediaDisplayBuilder)b).finalY;
        this.destinationY = ((ExpandedMediaDisplayBuilder)b).destinationY;
    }

    public static ExpandedMediaDisplayBuilder<?, ?> builder() {
        return new ExpandedMediaDisplayBuilderImpl();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setFinalY(float finalY) {
        this.finalY = finalY;
    }

    @Override
    public String toString() {
        return "ExpandedMediaDisplay(executable=" + this.getExecutable() + ", finalY=" + this.getFinalY() + ", destinationY=" + this.destinationY + ", sanitizer=" + this.sanitizer + ", optimizer=" + this.optimizer + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpandedMediaDisplay)) {
            return false;
        }
        ExpandedMediaDisplay other = (ExpandedMediaDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getFinalY(), other.getFinalY()) != 0) {
            return false;
        }
        if (this.destinationY != other.destinationY) {
            return false;
        }
        Executable this$executable = this.getExecutable();
        Executable other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
            return false;
        }
        TextSanitizer this$sanitizer = this.sanitizer;
        TextSanitizer other$sanitizer = other.sanitizer;
        if (this$sanitizer == null ? other$sanitizer != null : !this$sanitizer.equals(other$sanitizer)) {
            return false;
        }
        TextLengthOptimizer this$optimizer = this.optimizer;
        TextLengthOptimizer other$optimizer = other.optimizer;
        return !(this$optimizer == null ? other$optimizer != null : !this$optimizer.equals(other$optimizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExpandedMediaDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getFinalY());
        result = result * 59 + this.destinationY;
        Executable $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
        TextSanitizer $sanitizer = this.sanitizer;
        result = result * 59 + ($sanitizer == null ? 43 : $sanitizer.hashCode());
        TextLengthOptimizer $optimizer = this.optimizer;
        result = result * 59 + ($optimizer == null ? 43 : $optimizer.hashCode());
        return result;
    }

    public float getFinalY() {
        return this.finalY;
    }

    private static final class ExpandedMediaDisplayBuilderImpl
    extends ExpandedMediaDisplayBuilder<ExpandedMediaDisplay, ExpandedMediaDisplayBuilderImpl> {
        private ExpandedMediaDisplayBuilderImpl() {
        }

        @Override
        protected ExpandedMediaDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public ExpandedMediaDisplay build() {
            return new ExpandedMediaDisplay(this);
        }
    }

    public static abstract class ExpandedMediaDisplayBuilder<C extends ExpandedMediaDisplay, B extends ExpandedMediaDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Executable executable;
        private float finalY;
        private int destinationY;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B executable(Executable executable) {
            this.executable = executable;
            return (B)this.self();
        }

        public B finalY(float finalY) {
            this.finalY = finalY;
            return (B)this.self();
        }

        public B destinationY(int destinationY) {
            this.destinationY = destinationY;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ExpandedMediaDisplay.ExpandedMediaDisplayBuilder(super=" + super.toString() + ", executable=" + this.executable + ", finalY=" + this.finalY + ", destinationY=" + this.destinationY + ")";
        }
    }
}

