/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.tag;

import java.util.List;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.data.TagData;
import tech.grasshopper.pdf.pojo.cucumber.Tag;
import tech.grasshopper.pdf.section.tag.TagDisplay;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.structure.paginate.PaginationData;
import tech.grasshopper.pdf.structure.paginate.TagPaginator;

public class TagSection
extends PaginatedSection {
    static final String SECTION_TITLE = "TAGS SUMMARY";
    private final int maxDataCountPerPage;
    private TagData tagData;

    @Override
    public void generateDisplay(int fromIndex, int toIndex) {
        ((TagDisplay)((TagDisplay.TagDisplayBuilder)((TagDisplay.TagDisplayBuilder)((TagDisplay.TagDisplayBuilder)((TagDisplay.TagDisplayBuilder)((TagDisplay.TagDisplayBuilder)TagDisplay.builder().displayData(this.createDisplayData(fromIndex, toIndex))).document(this.document)).reportConfig(this.reportConfig)).destinations(this.destinations)).paginationData(PaginationData.builder().itemsPerPage(this.maxDataCountPerPage).itemFromIndex(fromIndex).itemToIndex(toIndex).build())).build()).display();
    }

    @Override
    public DisplayData createDisplayData(int fromIndex, int toIndex) {
        List<Tag> pageTags = this.tagData.getTags().subList(fromIndex, toIndex);
        return TagData.builder().tags(pageTags).build();
    }

    @Override
    public void createSection() {
        this.tagData = (TagData)this.displayData;
        if (this.tagData.getTags().isEmpty()) {
            return;
        }
        TagPaginator paginator = TagPaginator.builder().data(this.tagData).maxDataCountPerPage(this.maxDataCountPerPage).section(this).build();
        paginator.paginate();
    }

    protected TagSection(TagSectionBuilder<?, ?> b) {
        super((PaginatedSection.PaginatedSectionBuilder<?, ?>)b);
        this.maxDataCountPerPage = this.reportConfig.getTagConfig().dataCount();
        this.tagData = ((TagSectionBuilder)b).tagData;
    }

    public static TagSectionBuilder<?, ?> builder() {
        return new TagSectionBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagSection)) {
            return false;
        }
        TagSection other = (TagSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxDataCountPerPage != other.maxDataCountPerPage) {
            return false;
        }
        TagData this$tagData = this.tagData;
        TagData other$tagData = other.tagData;
        return !(this$tagData == null ? other$tagData != null : !this$tagData.equals(other$tagData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TagSection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxDataCountPerPage;
        TagData $tagData = this.tagData;
        result = result * 59 + ($tagData == null ? 43 : $tagData.hashCode());
        return result;
    }

    private static final class TagSectionBuilderImpl
    extends TagSectionBuilder<TagSection, TagSectionBuilderImpl> {
        private TagSectionBuilderImpl() {
        }

        @Override
        protected TagSectionBuilderImpl self() {
            return this;
        }

        @Override
        public TagSection build() {
            return new TagSection(this);
        }
    }

    public static abstract class TagSectionBuilder<C extends TagSection, B extends TagSectionBuilder<C, B>>
    extends PaginatedSection.PaginatedSectionBuilder<C, B> {
        private TagData tagData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B tagData(TagData tagData) {
            this.tagData = tagData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TagSection.TagSectionBuilder(super=" + super.toString() + ", tagData=" + this.tagData + ")";
        }
    }
}

