/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure;

import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import tech.grasshopper.pdf.structure.header.PageNumber;
import tech.grasshopper.pdf.structure.header.PageTitle;

public class PageCreator {
    private PDDocument document;

    public PDPage createPotraitPage() {
        return new PDPage(PDRectangle.A4);
    }

    public PDPage createLandscapePage() {
        return new PDPage(new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth()));
    }

    public PDPage createPotraitPageAndAddToDocument() {
        PDPage page = this.createPotraitPage();
        this.document.addPage(page);
        return page;
    }

    public PDPage createLandscapePageAndAddToDocument() {
        PDPage page = this.createLandscapePage();
        this.document.addPage(page);
        return page;
    }

    public PDPage createLandscapePageWithHeaderAndNumber(String title) {
        PDPage page = this.createLandscapePage();
        PDPageContentStream content = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.APPEND, true);
        PageTitle.builder().content(content).title(title).build().displayTitle();
        PageNumber.builder().content(content).number(this.document.getNumberOfPages() + 1).build().displayNumber();
        content.close();
        return page;
    }

    public PDPage createLandscapePageWithHeaderAndNumberAndAddToDocument(String title) {
        PDPage page = this.createLandscapePageWithHeaderAndNumber(title);
        this.document.addPage(page);
        return page;
    }

    public Supplier<PDPage> potraitPageSupplier() {
        return () -> this.createPotraitPage();
    }

    public Supplier<PDPage> landscapePageSupplier() {
        return () -> this.createLandscapePage();
    }

    public Supplier<PDPage> landscapePageWithHeaderAndNumberSupplier(String title) {
        return () -> this.createLandscapePageWithHeaderAndNumber(title);
    }

    PageCreator(PDDocument document) {
        this.document = document;
    }

    public static PageCreatorBuilder builder() {
        return new PageCreatorBuilder();
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public static class PageCreatorBuilder {
        private PDDocument document;

        PageCreatorBuilder() {
        }

        public PageCreatorBuilder document(PDDocument document) {
            this.document = document;
            return this;
        }

        public PageCreator build() {
            return new PageCreator(this.document);
        }

        public String toString() {
            return "PageCreator.PageCreatorBuilder(document=" + this.document + ")";
        }
    }
}

