/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.annotation;

import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;

public class AnnotationProcessor {
    private ReportData reportData;
    private ReportConfig reportConfig;

    public void updateDestination() {
        for (Feature feature : this.reportData.getFeatures()) {
            feature.getAnnotations().forEach(a -> this.updateDestination((Annotation)a, feature.getDestination()));
            for (Scenario scenario : feature.getScenarios()) {
                scenario.getAnnotations().forEach(a -> this.updateDestination((Annotation)a, scenario.getDestination()));
                for (Executable executable : scenario.getFilteredStepsAndHooks(this.reportConfig)) {
                    for (int i = 0; i < executable.getAnnotations().size(); ++i) {
                        this.updateDestination(executable.getAnnotations().get(i), executable.getDestinations().get(i));
                    }
                }
            }
        }
    }

    private void updateDestination(Annotation annotation, Destination destination) {
        if (annotation == null || destination == null) {
            return;
        }
        PDActionGoTo action = new PDActionGoTo();
        action.setDestination((PDDestination)destination.createPDPageDestination());
        PDAnnotationLink link = annotation.createPDAnnotationLink();
        link.setAction((PDAction)action);
        annotation.getPage().getAnnotations().add(link);
    }

    AnnotationProcessor(ReportData reportData, ReportConfig reportConfig) {
        this.reportData = reportData;
        this.reportConfig = reportConfig;
    }

    public static AnnotationProcessorBuilder builder() {
        return new AnnotationProcessorBuilder();
    }

    public static class AnnotationProcessorBuilder {
        private ReportData reportData;
        private ReportConfig reportConfig;

        AnnotationProcessorBuilder() {
        }

        public AnnotationProcessorBuilder reportData(ReportData reportData) {
            this.reportData = reportData;
            return this;
        }

        public AnnotationProcessorBuilder reportConfig(ReportConfig reportConfig) {
            this.reportConfig = reportConfig;
            return this;
        }

        public AnnotationProcessor build() {
            return new AnnotationProcessor(this.reportData, this.reportConfig);
        }

        public String toString() {
            return "AnnotationProcessor.AnnotationProcessorBuilder(reportData=" + this.reportData + ", reportConfig=" + this.reportConfig + ")";
        }
    }
}

