/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.attributes;

import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.data.AttributeData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Attribute;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.TableCreator;
import tech.grasshopper.pdf.structure.footer.CroppedMessage;
import tech.grasshopper.pdf.structure.paginate.PaginatedDisplay;
import tech.grasshopper.pdf.util.TextUtil;

public class AttributeDisplay
extends PaginatedDisplay
implements DestinationAware {
    private Table.TableBuilder tableBuilder;
    private String attributeType;
    private Consumer<Destination> attributeDestinationConsumer;
    private static final int TABLE_Y_AXIS_START = 530;
    private static final int TABLE_Y_AXIS_END = 60;
    private static final PDFont HEADER_FONT = ReportFont.BOLD_ITALIC_FONT;
    private static final int HEADER_FONT_SIZE = 14;
    private static final PDFont NAME_FONT = ReportFont.ITALIC_FONT;
    private static final int NAME_FONT_SIZE = 12;
    private static final PDFont DATA_FONT = ReportFont.ITALIC_FONT;
    private static final int DATA_FONT_SIZE = 11;
    private static final float ATTRIBUTE_NAME_COLUMN_WIDTH = 400.0f;
    private static final float HEADER_PADDING = 9.0f;
    private static final float ATTRIBUTE_PADDING = 8.0f;
    private static final float DATA_PADDING = 5.0f;
    public static final float TABLE_SPACE = 470.0f;
    public static final TextLengthOptimizer attributeNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(12).availableSpace(384.0f).maxLines(2).build();
    private boolean nameCropped;

    public static float headerRowHeight() {
        return TextUtil.builder().font(HEADER_FONT).fontSize(14).text("Attribute").width(400.0f).padding(9.0f).build().tableRowHeight() * 2.0f;
    }

    public static TextUtil attributeNameTextUtil() {
        return TextUtil.builder().font(NAME_FONT).fontSize(12).text("").width(400.0f).padding(8.0f).build();
    }

    @Override
    public void display() {
        this.page = PageCreator.builder().document(this.document).build().createLandscapePageWithHeaderAndNumberAndAddToDocument(this.attributeType + " SUMMARY");
        this.content = new PDPageContentStream(this.document, this.page, PDPageContentStream.AppendMode.APPEND, true);
        this.createTableBuilder();
        this.createHeaderRow();
        this.createDataRows();
        this.drawTable();
        this.croppedMessageDisplay();
        this.createDestination();
        this.content.close();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{400.0f, 45.0f, 45.0f, 45.0f, 45.0f, 45.0f, 45.0f, 45.0f, 45.0f}).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f);
    }

    private void createHeaderRow() {
        this.tableBuilder.addRow(Row.builder().padding(9.0f).horizontalAlignment(HorizontalAlignment.CENTER).font(HEADER_FONT).fontSize(Integer.valueOf(14)).verticalAlignment(VerticalAlignment.MIDDLE).add((AbstractCell)TextCell.builder().text(this.attributeType).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Scenario").colSpan(4)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Feature").colSpan(4)).build()).build()).addRow(Row.builder().padding(9.0f).horizontalAlignment(HorizontalAlignment.CENTER).font(HEADER_FONT).fontSize(Integer.valueOf(14)).verticalAlignment(VerticalAlignment.MIDDLE).add((AbstractCell)TextCell.builder().text("Name").build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("T").textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("P").textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("F").textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("S").textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("T").textColor(this.reportConfig.getScenarioConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("P").textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("F").textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("S").textColor(this.reportConfig.skippedColor())).build()).build());
    }

    private void createDataRows() {
        AttributeData attributeData = (AttributeData)this.displayData;
        List<? extends Attribute> attributes = attributeData.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attribute = attributes.get(i);
            this.tableBuilder.addRow(Row.builder().padding(5.0f).font(DATA_FONT).fontSize(Integer.valueOf(11)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.TOP).add(this.createAttributeNameCell(attribute)).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(attribute.getTotalScenarios())).textColor(this.reportConfig.getScenarioConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(attribute.getPassedScenarios())).textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(attribute.getFailedScenarios())).textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(attribute.getSkippedScenarios())).textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(attribute.getTotalFeatures())).textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(attribute.getPassedFeatures())).textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(attribute.getFailedFeatures())).textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(attribute.getSkippedFeatures())).textColor(this.reportConfig.skippedColor())).build()).build());
        }
    }

    private void drawTable() {
        Object tableDrawer = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(this.tableBuilder)).document(this.document)).startX(40.0f)).startY(530.0f)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageSupplier())).build();
        ((TableCreator)tableDrawer).displayTable();
    }

    private AbstractCell createAttributeNameCell(Attribute attr) {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        String attrName = sanitizer.sanitizeText(attributeNameTextOptimizer.optimizeTextLines(attr.getName()));
        if (attributeNameTextOptimizer.isTextTrimmed()) {
            this.nameCropped = true;
        }
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(attrName).padding(8.0f)).font(NAME_FONT)).fontSize(Integer.valueOf(12))).horizontalAlignment(HorizontalAlignment.LEFT)).textColor(this.statusColor(attr.getStatus()))).build();
    }

    private void croppedMessageDisplay() {
        if (this.nameCropped) {
            CroppedMessage.builder().content(this.content).message("* The " + this.attributeType + " name has been cropped to fit in the available space.").build().displayMessage();
        }
    }

    @Override
    public void createDestination() {
        Destination destination = Destination.builder().name(this.attributeType + "S - " + (this.paginationData.getItemFromIndex() + 1) + " to " + this.paginationData.getItemToIndex()).yCoord((int)this.page.getMediaBox().getHeight()).page(this.page).build();
        this.attributeDestinationConsumer.accept(destination);
    }

    protected AttributeDisplay(AttributeDisplayBuilder<?, ?> b) {
        super((PaginatedDisplay.PaginatedDisplayBuilder<?, ?>)b);
        this.tableBuilder = ((AttributeDisplayBuilder)b).tableBuilder;
        this.attributeType = ((AttributeDisplayBuilder)b).attributeType;
        this.attributeDestinationConsumer = ((AttributeDisplayBuilder)b).attributeDestinationConsumer;
        this.nameCropped = ((AttributeDisplayBuilder)b).nameCropped;
    }

    public static AttributeDisplayBuilder<?, ?> builder() {
        return new AttributeDisplayBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeDisplay)) {
            return false;
        }
        AttributeDisplay other = (AttributeDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nameCropped != other.nameCropped) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.tableBuilder;
        Table.TableBuilder other$tableBuilder = other.tableBuilder;
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        String this$attributeType = this.attributeType;
        String other$attributeType = other.attributeType;
        if (this$attributeType == null ? other$attributeType != null : !this$attributeType.equals(other$attributeType)) {
            return false;
        }
        Consumer<Destination> this$attributeDestinationConsumer = this.attributeDestinationConsumer;
        Consumer<Destination> other$attributeDestinationConsumer = other.attributeDestinationConsumer;
        return !(this$attributeDestinationConsumer == null ? other$attributeDestinationConsumer != null : !this$attributeDestinationConsumer.equals(other$attributeDestinationConsumer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AttributeDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nameCropped ? 79 : 97);
        Table.TableBuilder $tableBuilder = this.tableBuilder;
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        String $attributeType = this.attributeType;
        result = result * 59 + ($attributeType == null ? 43 : $attributeType.hashCode());
        Consumer<Destination> $attributeDestinationConsumer = this.attributeDestinationConsumer;
        result = result * 59 + ($attributeDestinationConsumer == null ? 43 : $attributeDestinationConsumer.hashCode());
        return result;
    }

    private static final class AttributeDisplayBuilderImpl
    extends AttributeDisplayBuilder<AttributeDisplay, AttributeDisplayBuilderImpl> {
        private AttributeDisplayBuilderImpl() {
        }

        @Override
        protected AttributeDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public AttributeDisplay build() {
            return new AttributeDisplay(this);
        }
    }

    public static abstract class AttributeDisplayBuilder<C extends AttributeDisplay, B extends AttributeDisplayBuilder<C, B>>
    extends PaginatedDisplay.PaginatedDisplayBuilder<C, B> {
        private Table.TableBuilder tableBuilder;
        private String attributeType;
        private Consumer<Destination> attributeDestinationConsumer;
        private boolean nameCropped;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B attributeType(String attributeType) {
            this.attributeType = attributeType;
            return (B)this.self();
        }

        public B attributeDestinationConsumer(Consumer<Destination> attributeDestinationConsumer) {
            this.attributeDestinationConsumer = attributeDestinationConsumer;
            return (B)this.self();
        }

        public B nameCropped(boolean nameCropped) {
            this.nameCropped = nameCropped;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AttributeDisplay.AttributeDisplayBuilder(super=" + super.toString() + ", tableBuilder=" + this.tableBuilder + ", attributeType=" + this.attributeType + ", attributeDestinationConsumer=" + this.attributeDestinationConsumer + ", nameCropped=" + this.nameCropped + ")";
        }
    }
}

