/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.scenario.nopass;

import java.awt.Color;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.section.scenario.ScenarioStepDetails;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.TableCreator;
import tech.grasshopper.pdf.util.TextUtil;

public class NoPassScenarioDisplay
extends ScenarioStepDetails
implements DestinationAware {
    private static final int TABLE_X_AXIS_START = 40;
    private static final int TABLE_Y_AXIS_START = 530;
    private static final float FEATURE_NAME_COLUMN_WIDTH = 350.0f;
    private static final float SCENARIO_NAME_COLUMN_WIDTH = 380.0f;
    public static final float TABLE_SPACE = 490.0f;
    public static final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(11).availableSpace(338.0f).maxLines(2).build();
    public static final TextLengthOptimizer scenarioNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(11).availableSpace(368.0f).maxLines(2).build();
    public static final TextUtil headerRowTextUtil = TextUtil.builder().font(HEADER_FONT).fontSize(12).text("Scenario Name").width(380.0f).padding(7.0f).build();
    public static final TextUtil featureNameTextUtil = TextUtil.builder().font(NAME_FONT).fontSize(11).text("").width(350.0f).padding(6.0f).build();
    public static final TextUtil scenarioNameTextUtil = TextUtil.builder().font(NAME_FONT).fontSize(11).text("").width(380.0f).padding(6.0f).build();

    @Override
    protected TextLengthOptimizer featureNameTextOptimizer() {
        return featureNameTextOptimizer;
    }

    @Override
    protected TextLengthOptimizer scenarioNameTextOptimizer() {
        return scenarioNameTextOptimizer;
    }

    @Override
    public void display() {
        this.page = PageCreator.builder().document(this.document).build().createLandscapePageWithHeaderAndNumberAndAddToDocument("FAIL & SKIP SCENARIOS");
        this.content = new PDPageContentStream(this.document, this.page, PDPageContentStream.AppendMode.APPEND, true);
        this.createTableBuilder();
        this.createHeaderRow();
        this.createDataRows();
        this.drawTable();
        this.croppedMessageDisplay();
        this.createDestination();
        this.content.close();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{25.0f, 350.0f, 380.0f}).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f);
    }

    private void createHeaderRow() {
        this.tableBuilder.addRow(Row.builder().padding(7.0f).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.MIDDLE).font(HEADER_FONT).fontSize(Integer.valueOf(12)).add((AbstractCell)TextCell.builder().text("#").build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Feature Name").horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Scenario Name").horizontalAlignment(HorizontalAlignment.LEFT)).build()).build());
    }

    private void createDataRows() {
        int sNo = this.paginationData.getItemFromIndex() + 1;
        ScenarioData scenarioData = (ScenarioData)this.displayData;
        List<Scenario> scenarios = scenarioData.getScenarios();
        int featureRowSpanSize = this.featureNameRowSpans.size();
        for (int i = 0; i < scenarios.size(); ++i) {
            Scenario scenario = scenarios.get(i);
            if (featureNameTextOptimizer.isTextTrimmed() || scenarioNameTextOptimizer.isTextTrimmed()) {
                this.nameCropped = true;
            }
            this.tableBuilder.addRow(Row.builder().padding(6.0f).font(NAME_FONT).fontSize(Integer.valueOf(11)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.TOP).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(sNo)).fontSize(Integer.valueOf(8))).build()).add(this.createFeatureNameCell(scenario.getFeature(), (Integer)this.featureNameRowSpans.get(i), i == featureRowSpanSize - 1)).add(this.createScenarioNameCell(scenario)).build());
            ++sNo;
        }
    }

    private void drawTable() {
        Object tableDrawer = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(this.tableBuilder)).document(this.document)).startX(40.0f)).startY(530.0f)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageSupplier())).build();
        ((TableCreator)tableDrawer).displayTable();
    }

    @Override
    protected boolean annotationFilter() {
        return this.reportConfig.isDisplayDetailed();
    }

    @Override
    public void createDestination() {
        Destination destination = Destination.builder().name("FAILED SCENARIOS - " + (this.paginationData.getItemFromIndex() + 1) + " to " + this.paginationData.getItemToIndex()).yCoord((int)this.page.getMediaBox().getHeight()).page(this.page).build();
        this.destinations.addFailSkipScenarioDestination(destination);
    }

    protected NoPassScenarioDisplay(NoPassScenarioDisplayBuilder<?, ?> b) {
        super((ScenarioStepDetails.ScenarioStepDetailsBuilder<?, ?>)b);
    }

    public static NoPassScenarioDisplayBuilder<?, ?> builder() {
        return new NoPassScenarioDisplayBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoPassScenarioDisplay)) {
            return false;
        }
        NoPassScenarioDisplay other = (NoPassScenarioDisplay)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NoPassScenarioDisplay;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class NoPassScenarioDisplayBuilderImpl
    extends NoPassScenarioDisplayBuilder<NoPassScenarioDisplay, NoPassScenarioDisplayBuilderImpl> {
        private NoPassScenarioDisplayBuilderImpl() {
        }

        @Override
        protected NoPassScenarioDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public NoPassScenarioDisplay build() {
            return new NoPassScenarioDisplay(this);
        }
    }

    public static abstract class NoPassScenarioDisplayBuilder<C extends NoPassScenarioDisplay, B extends NoPassScenarioDisplayBuilder<C, B>>
    extends ScenarioStepDetails.ScenarioStepDetailsBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "NoPassScenarioDisplay.NoPassScenarioDisplayBuilder(super=" + super.toString() + ")";
        }
    }
}

