/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.paginate;

import java.util.List;
import tech.grasshopper.pdf.data.AttributeData;
import tech.grasshopper.pdf.pojo.cucumber.Attribute;
import tech.grasshopper.pdf.section.attributes.AttributeDisplay;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.util.TextUtil;

public class AttributePaginator {
    private AttributeData data;
    private PaginatedSection section;
    private int maxDataCountPerPage;

    public void paginate() {
        float currentHeight = AttributeDisplay.headerRowHeight();
        int fromIndex = 0;
        int toIndex = 0;
        TextUtil textUtil = AttributeDisplay.attributeNameTextUtil();
        List<? extends Attribute> attributes = this.data.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            textUtil.setText(AttributeDisplay.attributeNameTextOptimizer.optimizeTextLines(attributes.get(i).getName()));
            if ((currentHeight += textUtil.tableRowHeight()) > 470.0f || toIndex - fromIndex + 1 > this.maxDataCountPerPage) {
                this.section.generateDisplay(fromIndex, toIndex);
                fromIndex = toIndex;
                currentHeight = AttributeDisplay.headerRowHeight();
                --i;
                continue;
            }
            ++toIndex;
        }
        this.section.generateDisplay(fromIndex, toIndex);
    }

    AttributePaginator(AttributeData data, PaginatedSection section, int maxDataCountPerPage) {
        this.data = data;
        this.section = section;
        this.maxDataCountPerPage = maxDataCountPerPage;
    }

    public static AttributePaginatorBuilder builder() {
        return new AttributePaginatorBuilder();
    }

    public static class AttributePaginatorBuilder {
        private AttributeData data;
        private PaginatedSection section;
        private int maxDataCountPerPage;

        AttributePaginatorBuilder() {
        }

        public AttributePaginatorBuilder data(AttributeData data) {
            this.data = data;
            return this;
        }

        public AttributePaginatorBuilder section(PaginatedSection section) {
            this.section = section;
            return this;
        }

        public AttributePaginatorBuilder maxDataCountPerPage(int maxDataCountPerPage) {
            this.maxDataCountPerPage = maxDataCountPerPage;
            return this;
        }

        public AttributePaginator build() {
            return new AttributePaginator(this.data, this.section, this.maxDataCountPerPage);
        }

        public String toString() {
            return "AttributePaginator.AttributePaginatorBuilder(data=" + this.data + ", section=" + this.section + ", maxDataCountPerPage=" + this.maxDataCountPerPage + ")";
        }
    }
}

