/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.paginate;

import java.util.ArrayList;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.section.scenario.ScenarioSection;
import tech.grasshopper.pdf.util.TextUtil;

public class ScenarioPaginator {
    private ScenarioData data;
    private ScenarioSection section;
    private int maxScenariosPerPage;
    private float tableSpace;
    private float headerRowHeight;
    private TextUtil textUtilFeature;
    private TextUtil textUtilScenario;
    private TextLengthOptimizer featureNameTextOptimizer;
    private TextLengthOptimizer scenarioNameTextOptimizer;

    public void paginate() {
        float currentHeight = this.headerRowHeight;
        int fromIndex = 0;
        int toIndex = 0;
        ArrayList<Integer> featureRowSpans = new ArrayList<Integer>();
        String firstUniqueFeatureName = "";
        int firstRowSpanIndex = 0;
        for (int i = 0; i < this.data.getScenarios().size(); ++i) {
            Scenario scenario = this.data.getScenarios().get(i);
            String featureName = scenario.getFeature().getName();
            if (featureName.equals(firstUniqueFeatureName)) {
                featureRowSpans.set(firstRowSpanIndex, (Integer)featureRowSpans.get(firstRowSpanIndex) + 1);
                featureRowSpans.add(0);
                featureName = "";
            } else {
                firstRowSpanIndex = featureRowSpans.size();
                firstUniqueFeatureName = featureName;
                featureRowSpans.add(1);
            }
            this.textUtilFeature.setText(this.featureNameTextOptimizer.optimizeTextLines(featureName));
            float featureHeight = this.textUtilFeature.tableRowHeight();
            this.textUtilScenario.setText(this.scenarioNameTextOptimizer.optimizeTextLines(scenario.getName()));
            float scenarioHeight = this.textUtilScenario.tableRowHeight();
            float f = scenarioHeight > featureHeight ? scenarioHeight : featureHeight;
            if ((currentHeight += f) > this.tableSpace || toIndex - fromIndex + 1 > this.maxScenariosPerPage) {
                if ((Integer)featureRowSpans.get(featureRowSpans.size() - 1) == 0) {
                    featureRowSpans.set(firstRowSpanIndex, (Integer)featureRowSpans.get(firstRowSpanIndex) - 1);
                }
                featureRowSpans.remove(featureRowSpans.size() - 1);
                this.section.setFeatureNameRowSpans(featureRowSpans);
                this.section.generateDisplay(fromIndex, toIndex);
                fromIndex = toIndex;
                featureRowSpans = new ArrayList();
                firstUniqueFeatureName = "";
                firstRowSpanIndex = 0;
                currentHeight = this.headerRowHeight;
                --i;
                continue;
            }
            ++toIndex;
        }
        this.section.setFeatureNameRowSpans(featureRowSpans);
        this.section.generateDisplay(fromIndex, toIndex);
    }

    ScenarioPaginator(ScenarioData data, ScenarioSection section, int maxScenariosPerPage, float tableSpace, float headerRowHeight, TextUtil textUtilFeature, TextUtil textUtilScenario, TextLengthOptimizer featureNameTextOptimizer, TextLengthOptimizer scenarioNameTextOptimizer) {
        this.data = data;
        this.section = section;
        this.maxScenariosPerPage = maxScenariosPerPage;
        this.tableSpace = tableSpace;
        this.headerRowHeight = headerRowHeight;
        this.textUtilFeature = textUtilFeature;
        this.textUtilScenario = textUtilScenario;
        this.featureNameTextOptimizer = featureNameTextOptimizer;
        this.scenarioNameTextOptimizer = scenarioNameTextOptimizer;
    }

    public static ScenarioPaginatorBuilder builder() {
        return new ScenarioPaginatorBuilder();
    }

    public static class ScenarioPaginatorBuilder {
        private ScenarioData data;
        private ScenarioSection section;
        private int maxScenariosPerPage;
        private float tableSpace;
        private float headerRowHeight;
        private TextUtil textUtilFeature;
        private TextUtil textUtilScenario;
        private TextLengthOptimizer featureNameTextOptimizer;
        private TextLengthOptimizer scenarioNameTextOptimizer;

        ScenarioPaginatorBuilder() {
        }

        public ScenarioPaginatorBuilder data(ScenarioData data) {
            this.data = data;
            return this;
        }

        public ScenarioPaginatorBuilder section(ScenarioSection section) {
            this.section = section;
            return this;
        }

        public ScenarioPaginatorBuilder maxScenariosPerPage(int maxScenariosPerPage) {
            this.maxScenariosPerPage = maxScenariosPerPage;
            return this;
        }

        public ScenarioPaginatorBuilder tableSpace(float tableSpace) {
            this.tableSpace = tableSpace;
            return this;
        }

        public ScenarioPaginatorBuilder headerRowHeight(float headerRowHeight) {
            this.headerRowHeight = headerRowHeight;
            return this;
        }

        public ScenarioPaginatorBuilder textUtilFeature(TextUtil textUtilFeature) {
            this.textUtilFeature = textUtilFeature;
            return this;
        }

        public ScenarioPaginatorBuilder textUtilScenario(TextUtil textUtilScenario) {
            this.textUtilScenario = textUtilScenario;
            return this;
        }

        public ScenarioPaginatorBuilder featureNameTextOptimizer(TextLengthOptimizer featureNameTextOptimizer) {
            this.featureNameTextOptimizer = featureNameTextOptimizer;
            return this;
        }

        public ScenarioPaginatorBuilder scenarioNameTextOptimizer(TextLengthOptimizer scenarioNameTextOptimizer) {
            this.scenarioNameTextOptimizer = scenarioNameTextOptimizer;
            return this;
        }

        public ScenarioPaginator build() {
            return new ScenarioPaginator(this.data, this.section, this.maxScenariosPerPage, this.tableSpace, this.headerRowHeight, this.textUtilFeature, this.textUtilScenario, this.featureNameTextOptimizer, this.scenarioNameTextOptimizer);
        }

        public String toString() {
            return "ScenarioPaginator.ScenarioPaginatorBuilder(data=" + this.data + ", section=" + this.section + ", maxScenariosPerPage=" + this.maxScenariosPerPage + ", tableSpace=" + this.tableSpace + ", headerRowHeight=" + this.headerRowHeight + ", textUtilFeature=" + this.textUtilFeature + ", textUtilScenario=" + this.textUtilScenario + ", featureNameTextOptimizer=" + this.featureNameTextOptimizer + ", scenarioNameTextOptimizer=" + this.scenarioNameTextOptimizer + ")";
        }
    }
}

