/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.yaml.snakeyaml.Yaml;
import tech.grasshopper.pdf.annotation.AnnotationProcessor;
import tech.grasshopper.pdf.annotation.FileAnnotationProcessor;
import tech.grasshopper.pdf.config.ParameterConfig;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.outline.Outline;
import tech.grasshopper.pdf.section.attributes.AuthorSection;
import tech.grasshopper.pdf.section.attributes.DeviceSection;
import tech.grasshopper.pdf.section.attributes.TagSection;
import tech.grasshopper.pdf.section.dashboard.Dashboard;
import tech.grasshopper.pdf.section.details.DetailedSection;
import tech.grasshopper.pdf.section.details.executable.MediaCleanup;
import tech.grasshopper.pdf.section.expanded.ExpandedSection;
import tech.grasshopper.pdf.section.feature.FeatureSection;
import tech.grasshopper.pdf.section.scenario.ScenarioSection;
import tech.grasshopper.pdf.section.scenario.nopass.NoPassScenarioSection;
import tech.grasshopper.pdf.section.summary.SummarySection;

public class PDFCucumberReport {
    private static final Logger logger = Logger.getLogger(PDFCucumberReport.class.getName());
    protected ReportData reportData;
    protected File reportFile;
    protected PDDocument document;
    private Destination.DestinationStore destinations;
    protected ReportConfig reportConfig;
    private MediaCleanup.MediaCleanupOption mediaCleanupOption;

    public PDFCucumberReport(ReportData reportData, String reportDirectory) {
        this(reportData, reportDirectory, MediaCleanup.MediaCleanupOption.builder().cleanUpType(MediaCleanup.CleanupType.NONE).build());
    }

    public PDFCucumberReport(ReportData reportData, File reportFile) {
        this(reportData, reportFile, MediaCleanup.MediaCleanupOption.builder().cleanUpType(MediaCleanup.CleanupType.NONE).build());
    }

    public PDFCucumberReport(ReportData reportData, String reportDirectory, MediaCleanup.MediaCleanupOption mediaCleanupOption) {
        this(reportData, new File(reportDirectory + "/report.pdf"), mediaCleanupOption);
    }

    public PDFCucumberReport(ReportData reportData, File reportFile, MediaCleanup.MediaCleanupOption mediaCleanupOption) {
        this.reportData = reportData;
        this.reportFile = reportFile;
        this.document = new PDDocument();
        this.destinations = new Destination.DestinationStore();
        this.mediaCleanupOption = mediaCleanupOption;
        ReportFont.loadReportFontFamily(this.document);
        this.createReportDirectory(this.reportFile.getParent());
        this.collectReportConfiguration();
        reportData.setReportConfig(this.reportConfig);
        reportData.populateSectionData();
        reportData.checkData();
    }

    public void setParameterConfig(ParameterConfig parameterConfig) {
        this.reportConfig.mergeParameterConfig(parameterConfig);
    }

    private void createReportDirectory(String reportDirectory) {
        File dir = new File(reportDirectory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private void collectReportConfiguration() {
        Yaml yaml = new Yaml();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream("src/test/resources/pdf-config.yaml");
            this.reportConfig = (ReportConfig)yaml.loadAs((InputStream)inputStream, ReportConfig.class);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.INFO, "PDF report configuration YAML file not found. Using default settings.");
            this.reportConfig = new ReportConfig();
        }
    }

    public void createReport() {
        this.verifyReportConfig();
        this.createDashboardSection();
        this.createSummarySection();
        this.createNotPassedScenarioSection();
        this.createTagSection();
        this.createDeviceSection();
        this.createAuthorSection();
        this.createFeatureSection();
        this.createScenarioSection();
        this.createDetailedSection();
        this.createExpandedSection();
        this.processDestinationAnnotations();
        this.processFileAnnotations();
        Outline.createDocumentOutline(this.document, this.reportConfig, this.destinations, this.reportData);
        MediaCleanup.builder().executableData(this.reportData.getExecutableData()).mediaCleanupOption(this.mediaCleanupOption).build().deleteMedia();
        try {
            this.document.save(this.reportFile);
            this.document.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }

    protected void verifyReportConfig() {
        this.reportConfig.verifyAndUpdate();
    }

    protected void createDashboardSection() {
        ((Dashboard)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)Dashboard.builder().displayData(this.reportData.getSummaryData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build()).createSection();
    }

    protected void createSummarySection() {
        ((SummarySection)((SummarySection.SummarySectionBuilder)((SummarySection.SummarySectionBuilder)((SummarySection.SummarySectionBuilder)((SummarySection.SummarySectionBuilder)SummarySection.builder().displayData(this.reportData.getFeatureData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build()).createSection();
    }

    protected void createNotPassedScenarioSection() {
        if (!this.reportData.getNotPassedScenarioData().getScenarios().isEmpty()) {
            ((NoPassScenarioSection.NoPassScenarioSectionBuilder)((NoPassScenarioSection.NoPassScenarioSectionBuilder)((NoPassScenarioSection.NoPassScenarioSectionBuilder)((NoPassScenarioSection.NoPassScenarioSectionBuilder)NoPassScenarioSection.builder().displayData(this.reportData.getNotPassedScenarioData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build().createSection();
        }
    }

    protected void createTagSection() {
        if (this.reportConfig.isDisplayTag() && !this.reportData.getTagData().getTags().isEmpty()) {
            ((TagSection.TagSectionBuilder)((TagSection.TagSectionBuilder)((TagSection.TagSectionBuilder)((TagSection.TagSectionBuilder)TagSection.builder().displayData(this.reportData.getTagData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build().createSection();
        }
    }

    protected void createDeviceSection() {
        if (this.reportConfig.isDisplayDevice() && !this.reportData.getDeviceData().getDevices().isEmpty()) {
            ((DeviceSection.DeviceSectionBuilder)((DeviceSection.DeviceSectionBuilder)((DeviceSection.DeviceSectionBuilder)((DeviceSection.DeviceSectionBuilder)DeviceSection.builder().displayData(this.reportData.getDeviceData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build().createSection();
        }
    }

    protected void createAuthorSection() {
        if (this.reportConfig.isDisplayAuthor() && !this.reportData.getAuthorData().getAuthors().isEmpty()) {
            ((AuthorSection.AuthorSectionBuilder)((AuthorSection.AuthorSectionBuilder)((AuthorSection.AuthorSectionBuilder)((AuthorSection.AuthorSectionBuilder)AuthorSection.builder().displayData(this.reportData.getAuthorData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build().createSection();
        }
    }

    protected void createFeatureSection() {
        if (this.reportConfig.isDisplayFeature()) {
            ((FeatureSection)((FeatureSection.FeatureSectionBuilder)((FeatureSection.FeatureSectionBuilder)((FeatureSection.FeatureSectionBuilder)((FeatureSection.FeatureSectionBuilder)FeatureSection.builder().displayData(this.reportData.getFeatureData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build()).createSection();
        }
    }

    protected void createScenarioSection() {
        if (this.reportConfig.isDisplayScenario()) {
            ((ScenarioSection)((ScenarioSection.ScenarioSectionBuilder)((ScenarioSection.ScenarioSectionBuilder)((ScenarioSection.ScenarioSectionBuilder)((ScenarioSection.ScenarioSectionBuilder)ScenarioSection.builder().displayData(this.reportData.getScenarioData())).reportConfig(this.reportConfig)).document(this.document)).destinations(this.destinations)).build()).createSection();
        }
    }

    protected void createDetailedSection() {
        if (this.reportConfig.isDisplayDetailed()) {
            ((DetailedSection)((DetailedSection.DetailedSectionBuilder)((DetailedSection.DetailedSectionBuilder)((DetailedSection.DetailedSectionBuilder)DetailedSection.builder().displayData(this.reportData.getFeatureData())).reportConfig(this.reportConfig)).document(this.document)).build()).createSection();
        }
    }

    protected void createExpandedSection() {
        if (this.reportConfig.isDisplayExpanded()) {
            ((ExpandedSection)((ExpandedSection.ExpandedSectionBuilder)((ExpandedSection.ExpandedSectionBuilder)((ExpandedSection.ExpandedSectionBuilder)ExpandedSection.builder().displayData(this.reportData.getExecutableData())).reportConfig(this.reportConfig)).document(this.document)).build()).createSection();
        }
    }

    protected void processDestinationAnnotations() {
        AnnotationProcessor.builder().reportData(this.reportData).reportConfig(this.reportConfig).build().updateDestination();
    }

    protected void processFileAnnotations() {
        FileAnnotationProcessor.builder().reportData(this.reportData).document(this.document).build().updateAttachments();
    }
}

