/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.data;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.AttributeData;
import tech.grasshopper.pdf.data.DashboardData;
import tech.grasshopper.pdf.data.ExecutableData;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.cucumber.Attribute;
import tech.grasshopper.pdf.pojo.cucumber.Author;
import tech.grasshopper.pdf.pojo.cucumber.BaseEntity;
import tech.grasshopper.pdf.pojo.cucumber.Device;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.pojo.cucumber.Tag;

public class ReportData {
    private List<Feature> features;
    private DashboardData summaryData;
    private FeatureData featureData;
    private ScenarioData scenarioData;
    private ExecutableData executableData;
    private ScenarioData notPassedScenarioData;
    private AttributeData.TagData tagData;
    private AttributeData.DeviceData deviceData;
    private AttributeData.AuthorData authorData;
    private ReportConfig reportConfig;

    public void checkData() {
        if (this.features == null || this.features.size() == 0) {
            throw new PdfReportException("No features present in test execution.");
        }
        for (Feature feature : this.features) {
            feature.checkData();
            for (Scenario scenario : feature.getScenarios()) {
                scenario.checkData();
                for (Executable executable : scenario.getStepsAndHooks()) {
                    executable.checkData();
                }
            }
        }
    }

    public void populateSectionData() {
        this.populateCounts();
        this.populateDashboardData();
        this.populateFeaturesScenariosStepsData();
        this.populateTagData();
        this.populateDeviceData();
        this.populateAuthorData();
    }

    private void populateCounts() {
        if (this.features == null || this.features.size() == 0) {
            throw new PdfReportException("No features present in test execution.");
        }
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                for (Step step : scenario.getSteps()) {
                    if (step.getStatus() == Status.PASSED) {
                        scenario.setPassedSteps(scenario.getPassedSteps() + 1);
                        feature.setPassedSteps(feature.getPassedSteps() + 1);
                    } else if (step.getStatus() == Status.FAILED) {
                        scenario.setFailedSteps(scenario.getFailedSteps() + 1);
                        feature.setFailedSteps(feature.getFailedSteps() + 1);
                    } else {
                        scenario.setSkippedSteps(scenario.getSkippedSteps() + 1);
                        feature.setSkippedSteps(feature.getSkippedSteps() + 1);
                    }
                    scenario.setTotalSteps(scenario.getTotalSteps() + 1);
                    feature.setTotalSteps(feature.getTotalSteps() + 1);
                }
                if (scenario.getStatus() == Status.PASSED) {
                    feature.setPassedScenarios(feature.getPassedScenarios() + 1);
                } else if (scenario.getStatus() == Status.FAILED) {
                    feature.setFailedScenarios(feature.getFailedScenarios() + 1);
                } else {
                    feature.setSkippedScenarios(feature.getSkippedScenarios() + 1);
                }
                feature.setTotalScenarios(feature.getTotalScenarios() + 1);
            }
        }
    }

    private void populateDashboardData() {
        this.summaryData = DashboardData.builder().testRunStartTime((LocalDateTime)Collections.min(this.features.stream().map(BaseEntity::getStartTime).collect(Collectors.toList()))).testRunEndTime((LocalDateTime)Collections.max(this.features.stream().map(BaseEntity::getEndTime).collect(Collectors.toList()))).build();
        for (Feature feature : this.features) {
            if (feature.getStatus() == Status.PASSED) {
                this.summaryData.setPassedFeatures(this.summaryData.getPassedFeatures() + 1);
            } else if (feature.getStatus() == Status.FAILED) {
                this.summaryData.setFailedFeatures(this.summaryData.getFailedFeatures() + 1);
            } else {
                this.summaryData.setSkippedFeatures(this.summaryData.getSkippedFeatures() + 1);
            }
            this.summaryData.setTotalFeatures(this.summaryData.getTotalFeatures() + 1);
            this.summaryData.setPassedScenarios(this.summaryData.getPassedScenarios() + feature.getPassedScenarios());
            this.summaryData.setFailedScenarios(this.summaryData.getFailedScenarios() + feature.getFailedScenarios());
            this.summaryData.setSkippedScenarios(this.summaryData.getSkippedScenarios() + feature.getSkippedScenarios());
            this.summaryData.setTotalScenarios(this.summaryData.getTotalScenarios() + feature.getTotalScenarios());
            this.summaryData.setPassedSteps(this.summaryData.getPassedSteps() + feature.getPassedSteps());
            this.summaryData.setFailedSteps(this.summaryData.getFailedSteps() + feature.getFailedSteps());
            this.summaryData.setSkippedSteps(this.summaryData.getSkippedSteps() + feature.getSkippedSteps());
            this.summaryData.setTotalSteps(this.summaryData.getTotalSteps() + feature.getTotalSteps());
        }
    }

    private void populateFeaturesScenariosStepsData() {
        this.featureData = FeatureData.builder().features(this.features).build();
        this.scenarioData = ScenarioData.builder().build();
        this.executableData = ExecutableData.builder().build();
        this.notPassedScenarioData = ScenarioData.builder().build();
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                scenario.setFeature(feature);
                this.scenarioData.getScenarios().add(scenario);
                if (scenario.getStatus() != Status.PASSED) {
                    this.notPassedScenarioData.getScenarios().add(scenario);
                }
                for (Executable executable : scenario.getFilteredStepsAndHooks(this.reportConfig)) {
                    executable.setScenario(scenario);
                    executable.setFeature(feature);
                    this.executableData.getExecutables().add(executable);
                }
            }
        }
    }

    private void populateTagData() {
        this.tagData = AttributeData.TagData.builder().build();
        List<Tag> tags = this.tagData.getTags();
        this.populateAttributeData(Tag::new, tags);
    }

    private void populateDeviceData() {
        this.deviceData = AttributeData.DeviceData.builder().build();
        List<Device> devices = this.deviceData.getDevices();
        this.populateAttributeData(Device::new, devices);
    }

    private void populateAuthorData() {
        this.authorData = AttributeData.AuthorData.builder().build();
        List<Author> authors = this.authorData.getAuthors();
        this.populateAttributeData(Author::new, authors);
    }

    private <T extends Attribute> void populateAttributeData(Function<String, T> newAttribute, List<T> attributes) {
        Class<?> clzAttr = ((Attribute)newAttribute.apply("")).getClass();
        for (Feature feature : this.features) {
            ArrayList<String> featureAttr = new ArrayList<String>();
            for (Scenario scenario : feature.getScenarios()) {
                for (String attrName : scenario.getAttributes(clzAttr)) {
                    Attribute attr = (Attribute)newAttribute.apply(attrName);
                    int attrIndex = attributes.indexOf(attr);
                    if (attrIndex > -1) {
                        attr = (Attribute)attributes.get(attrIndex);
                    } else {
                        attributes.add(attr);
                    }
                    if (scenario.getStatus() == Status.PASSED) {
                        attr.setPassedScenarios(attr.getPassedScenarios() + 1);
                    } else if (scenario.getStatus() == Status.FAILED) {
                        attr.setFailedScenarios(attr.getFailedScenarios() + 1);
                    } else {
                        attr.setSkippedScenarios(attr.getSkippedScenarios() + 1);
                    }
                    attr.setTotalScenarios(attr.getTotalScenarios() + 1);
                    if (featureAttr.contains(attrName)) continue;
                    if (feature.getStatus() == Status.PASSED) {
                        attr.setPassedFeatures(attr.getPassedFeatures() + 1);
                    } else if (feature.getStatus() == Status.FAILED) {
                        attr.setFailedFeatures(attr.getFailedFeatures() + 1);
                    } else {
                        attr.setSkippedFeatures(attr.getSkippedFeatures() + 1);
                    }
                    attr.setTotalFeatures(attr.getTotalFeatures() + 1);
                    featureAttr.add(attrName);
                }
            }
        }
        for (Attribute attr : attributes) {
            if (attr.getFailedScenarios() > 0 || attr.getFailedFeatures() > 0) {
                attr.setStatus(Status.FAILED);
                continue;
            }
            if (attr.getPassedScenarios() == attr.getTotalScenarios() && attr.getFailedScenarios() == 0 && attr.getPassedFeatures() == attr.getTotalFeatures() && attr.getFailedFeatures() == 0) {
                attr.setStatus(Status.PASSED);
                continue;
            }
            attr.setStatus(Status.SKIPPED);
        }
    }

    ReportData(List<Feature> features, DashboardData summaryData, FeatureData featureData, ScenarioData scenarioData, ExecutableData executableData, ScenarioData notPassedScenarioData, AttributeData.TagData tagData, AttributeData.DeviceData deviceData, AttributeData.AuthorData authorData, ReportConfig reportConfig) {
        this.features = features;
        this.summaryData = summaryData;
        this.featureData = featureData;
        this.scenarioData = scenarioData;
        this.executableData = executableData;
        this.notPassedScenarioData = notPassedScenarioData;
        this.tagData = tagData;
        this.deviceData = deviceData;
        this.authorData = authorData;
        this.reportConfig = reportConfig;
    }

    public static ReportDataBuilder builder() {
        return new ReportDataBuilder();
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public DashboardData getSummaryData() {
        return this.summaryData;
    }

    public FeatureData getFeatureData() {
        return this.featureData;
    }

    public ScenarioData getScenarioData() {
        return this.scenarioData;
    }

    public ExecutableData getExecutableData() {
        return this.executableData;
    }

    public ScenarioData getNotPassedScenarioData() {
        return this.notPassedScenarioData;
    }

    public AttributeData.TagData getTagData() {
        return this.tagData;
    }

    public AttributeData.DeviceData getDeviceData() {
        return this.deviceData;
    }

    public AttributeData.AuthorData getAuthorData() {
        return this.authorData;
    }

    public ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public void setReportConfig(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public static class ReportDataBuilder {
        private List<Feature> features;
        private DashboardData summaryData;
        private FeatureData featureData;
        private ScenarioData scenarioData;
        private ExecutableData executableData;
        private ScenarioData notPassedScenarioData;
        private AttributeData.TagData tagData;
        private AttributeData.DeviceData deviceData;
        private AttributeData.AuthorData authorData;
        private ReportConfig reportConfig;

        ReportDataBuilder() {
        }

        public ReportDataBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public ReportDataBuilder summaryData(DashboardData summaryData) {
            this.summaryData = summaryData;
            return this;
        }

        public ReportDataBuilder featureData(FeatureData featureData) {
            this.featureData = featureData;
            return this;
        }

        public ReportDataBuilder scenarioData(ScenarioData scenarioData) {
            this.scenarioData = scenarioData;
            return this;
        }

        public ReportDataBuilder executableData(ExecutableData executableData) {
            this.executableData = executableData;
            return this;
        }

        public ReportDataBuilder notPassedScenarioData(ScenarioData notPassedScenarioData) {
            this.notPassedScenarioData = notPassedScenarioData;
            return this;
        }

        public ReportDataBuilder tagData(AttributeData.TagData tagData) {
            this.tagData = tagData;
            return this;
        }

        public ReportDataBuilder deviceData(AttributeData.DeviceData deviceData) {
            this.deviceData = deviceData;
            return this;
        }

        public ReportDataBuilder authorData(AttributeData.AuthorData authorData) {
            this.authorData = authorData;
            return this;
        }

        public ReportDataBuilder reportConfig(ReportConfig reportConfig) {
            this.reportConfig = reportConfig;
            return this;
        }

        public ReportData build() {
            return new ReportData(this.features, this.summaryData, this.featureData, this.scenarioData, this.executableData, this.notPassedScenarioData, this.tagData, this.deviceData, this.authorData, this.reportConfig);
        }

        public String toString() {
            return "ReportData.ReportDataBuilder(features=" + this.features + ", summaryData=" + this.summaryData + ", featureData=" + this.featureData + ", scenarioData=" + this.scenarioData + ", executableData=" + this.executableData + ", notPassedScenarioData=" + this.notPassedScenarioData + ", tagData=" + this.tagData + ", deviceData=" + this.deviceData + ", authorData=" + this.authorData + ", reportConfig=" + this.reportConfig + ")";
        }
    }
}

