/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.optimizer;

import org.apache.pdfbox.pdmodel.font.PDFont;
import tech.grasshopper.pdf.font.ReportFont;

public class TextSanitizer {
    private PDFont font;
    private String replaceBy;
    private String replaceTabBy;
    private boolean tabStripped;
    private boolean glyphAbsentStripped;

    public String tabStripMessage() {
        return "TAB character is replaced by '" + this.replaceTabBy + "'.";
    }

    public String glyphAbsentStripMessage() {
        return "Not displayable characters are replaced by '" + this.replaceBy + "'.";
    }

    public String getStripMessage() {
        Object message = "";
        if (this.tabStripped) {
            message = "* " + this.tabStripMessage();
        }
        if (this.glyphAbsentStripped) {
            message = ((String)message).isEmpty() ? "* " : " ";
            message = (String)message + this.glyphAbsentStripMessage();
        }
        return message;
    }

    public String sanitizeText(String text) {
        StringBuffer strBuf = new StringBuffer();
        try {
            this.font.encode(text);
            return text;
        }
        catch (Exception e) {
            char[] chars;
            char[] cArray = chars = text.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character character = Character.valueOf(cArray[i]);
                try {
                    if (character.equals(Character.valueOf('\t'))) {
                        strBuf.append(this.replaceTabBy);
                        continue;
                    }
                    if (character.equals(Character.valueOf('\r')) || character.equals(Character.valueOf('\n'))) {
                        strBuf.append(character);
                        continue;
                    }
                    this.font.encode(character.toString());
                    strBuf.append(character);
                    continue;
                }
                catch (Exception ex) {
                    this.glyphAbsentStripped = true;
                    strBuf.append(this.replaceBy);
                }
            }
            return strBuf.toString();
        }
    }

    private static PDFont $default$font() {
        return ReportFont.REGULAR_FONT;
    }

    private static String $default$replaceBy() {
        return "?";
    }

    private static String $default$replaceTabBy() {
        return "    ";
    }

    private static boolean $default$tabStripped() {
        return false;
    }

    private static boolean $default$glyphAbsentStripped() {
        return false;
    }

    TextSanitizer(PDFont font, String replaceBy, String replaceTabBy, boolean tabStripped, boolean glyphAbsentStripped) {
        this.font = font;
        this.replaceBy = replaceBy;
        this.replaceTabBy = replaceTabBy;
        this.tabStripped = tabStripped;
        this.glyphAbsentStripped = glyphAbsentStripped;
    }

    public static TextSanitizerBuilder builder() {
        return new TextSanitizerBuilder();
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setReplaceBy(String replaceBy) {
        this.replaceBy = replaceBy;
    }

    public void setReplaceTabBy(String replaceTabBy) {
        this.replaceTabBy = replaceTabBy;
    }

    public void setTabStripped(boolean tabStripped) {
        this.tabStripped = tabStripped;
    }

    public void setGlyphAbsentStripped(boolean glyphAbsentStripped) {
        this.glyphAbsentStripped = glyphAbsentStripped;
    }

    public boolean isTabStripped() {
        return this.tabStripped;
    }

    public boolean isGlyphAbsentStripped() {
        return this.glyphAbsentStripped;
    }

    public static class TextSanitizerBuilder {
        private boolean font$set;
        private PDFont font$value;
        private boolean replaceBy$set;
        private String replaceBy$value;
        private boolean replaceTabBy$set;
        private String replaceTabBy$value;
        private boolean tabStripped$set;
        private boolean tabStripped$value;
        private boolean glyphAbsentStripped$set;
        private boolean glyphAbsentStripped$value;

        TextSanitizerBuilder() {
        }

        public TextSanitizerBuilder font(PDFont font) {
            this.font$value = font;
            this.font$set = true;
            return this;
        }

        public TextSanitizerBuilder replaceBy(String replaceBy) {
            this.replaceBy$value = replaceBy;
            this.replaceBy$set = true;
            return this;
        }

        public TextSanitizerBuilder replaceTabBy(String replaceTabBy) {
            this.replaceTabBy$value = replaceTabBy;
            this.replaceTabBy$set = true;
            return this;
        }

        public TextSanitizerBuilder tabStripped(boolean tabStripped) {
            this.tabStripped$value = tabStripped;
            this.tabStripped$set = true;
            return this;
        }

        public TextSanitizerBuilder glyphAbsentStripped(boolean glyphAbsentStripped) {
            this.glyphAbsentStripped$value = glyphAbsentStripped;
            this.glyphAbsentStripped$set = true;
            return this;
        }

        public TextSanitizer build() {
            PDFont font$value = this.font$value;
            if (!this.font$set) {
                font$value = TextSanitizer.$default$font();
            }
            String replaceBy$value = this.replaceBy$value;
            if (!this.replaceBy$set) {
                replaceBy$value = TextSanitizer.$default$replaceBy();
            }
            String replaceTabBy$value = this.replaceTabBy$value;
            if (!this.replaceTabBy$set) {
                replaceTabBy$value = TextSanitizer.$default$replaceTabBy();
            }
            boolean tabStripped$value = this.tabStripped$value;
            if (!this.tabStripped$set) {
                tabStripped$value = TextSanitizer.$default$tabStripped();
            }
            boolean glyphAbsentStripped$value = this.glyphAbsentStripped$value;
            if (!this.glyphAbsentStripped$set) {
                glyphAbsentStripped$value = TextSanitizer.$default$glyphAbsentStripped();
            }
            return new TextSanitizer(font$value, replaceBy$value, replaceTabBy$value, tabStripped$value, glyphAbsentStripped$value);
        }

        public String toString() {
            return "TextSanitizer.TextSanitizerBuilder(font$value=" + this.font$value + ", replaceBy$value=" + this.replaceBy$value + ", replaceTabBy$value=" + this.replaceTabBy$value + ", tabStripped$value=" + this.tabStripped$value + ", glyphAbsentStripped$value=" + this.glyphAbsentStripped$value + ")";
        }
    }
}

