/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.pojo.cucumber;

import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.cucumber.NonExecutable;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;

public class Feature
extends NonExecutable {
    private List<Scenario> scenarios;
    private int passedScenarios;
    private int failedScenarios;
    private int skippedScenarios;
    private int totalScenarios;
    private int passedSteps;
    private int failedSteps;
    private int skippedSteps;
    private int totalSteps;

    @Override
    public void checkData() {
        if (this.name == null || this.name.isEmpty()) {
            throw new PdfReportException("Feature name is null or empty.");
        }
        if (this.scenarios == null || this.scenarios.isEmpty()) {
            throw new PdfReportException("No scenarios present for feature - " + this.getName());
        }
        if (this.status == null) {
            throw new PdfReportException("No status present for feature - " + this.getName());
        }
        super.checkData();
    }

    private static List<Scenario> $default$scenarios() {
        return new ArrayList<Scenario>();
    }

    private static int $default$passedScenarios() {
        return 0;
    }

    private static int $default$failedScenarios() {
        return 0;
    }

    private static int $default$skippedScenarios() {
        return 0;
    }

    private static int $default$totalScenarios() {
        return 0;
    }

    private static int $default$passedSteps() {
        return 0;
    }

    private static int $default$failedSteps() {
        return 0;
    }

    private static int $default$skippedSteps() {
        return 0;
    }

    private static int $default$totalSteps() {
        return 0;
    }

    protected Feature(FeatureBuilder<?, ?> b) {
        super((NonExecutable.NonExecutableBuilder<?, ?>)b);
        this.scenarios = b.scenarios$set ? b.scenarios$value : Feature.$default$scenarios();
        this.passedScenarios = b.passedScenarios$set ? b.passedScenarios$value : Feature.$default$passedScenarios();
        this.failedScenarios = b.failedScenarios$set ? b.failedScenarios$value : Feature.$default$failedScenarios();
        this.skippedScenarios = b.skippedScenarios$set ? b.skippedScenarios$value : Feature.$default$skippedScenarios();
        this.totalScenarios = b.totalScenarios$set ? b.totalScenarios$value : Feature.$default$totalScenarios();
        this.passedSteps = b.passedSteps$set ? b.passedSteps$value : Feature.$default$passedSteps();
        this.failedSteps = b.failedSteps$set ? b.failedSteps$value : Feature.$default$failedSteps();
        this.skippedSteps = b.skippedSteps$set ? b.skippedSteps$value : Feature.$default$skippedSteps();
        this.totalSteps = b.totalSteps$set ? b.totalSteps$value : Feature.$default$totalSteps();
    }

    public static FeatureBuilder<?, ?> builder() {
        return new FeatureBuilderImpl();
    }

    public List<Scenario> getScenarios() {
        return this.scenarios;
    }

    public int getPassedScenarios() {
        return this.passedScenarios;
    }

    public int getFailedScenarios() {
        return this.failedScenarios;
    }

    public int getSkippedScenarios() {
        return this.skippedScenarios;
    }

    public int getTotalScenarios() {
        return this.totalScenarios;
    }

    public int getPassedSteps() {
        return this.passedSteps;
    }

    public int getFailedSteps() {
        return this.failedSteps;
    }

    public int getSkippedSteps() {
        return this.skippedSteps;
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public void setScenarios(List<Scenario> scenarios) {
        this.scenarios = scenarios;
    }

    public void setPassedScenarios(int passedScenarios) {
        this.passedScenarios = passedScenarios;
    }

    public void setFailedScenarios(int failedScenarios) {
        this.failedScenarios = failedScenarios;
    }

    public void setSkippedScenarios(int skippedScenarios) {
        this.skippedScenarios = skippedScenarios;
    }

    public void setTotalScenarios(int totalScenarios) {
        this.totalScenarios = totalScenarios;
    }

    public void setPassedSteps(int passedSteps) {
        this.passedSteps = passedSteps;
    }

    public void setFailedSteps(int failedSteps) {
        this.failedSteps = failedSteps;
    }

    public void setSkippedSteps(int skippedSteps) {
        this.skippedSteps = skippedSteps;
    }

    public void setTotalSteps(int totalSteps) {
        this.totalSteps = totalSteps;
    }

    @Override
    public String toString() {
        return "Feature(scenarios=" + this.getScenarios() + ", passedScenarios=" + this.getPassedScenarios() + ", failedScenarios=" + this.getFailedScenarios() + ", skippedScenarios=" + this.getSkippedScenarios() + ", totalScenarios=" + this.getTotalScenarios() + ", passedSteps=" + this.getPassedSteps() + ", failedSteps=" + this.getFailedSteps() + ", skippedSteps=" + this.getSkippedSteps() + ", totalSteps=" + this.getTotalSteps() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPassedScenarios() != other.getPassedScenarios()) {
            return false;
        }
        if (this.getFailedScenarios() != other.getFailedScenarios()) {
            return false;
        }
        if (this.getSkippedScenarios() != other.getSkippedScenarios()) {
            return false;
        }
        if (this.getTotalScenarios() != other.getTotalScenarios()) {
            return false;
        }
        if (this.getPassedSteps() != other.getPassedSteps()) {
            return false;
        }
        if (this.getFailedSteps() != other.getFailedSteps()) {
            return false;
        }
        if (this.getSkippedSteps() != other.getSkippedSteps()) {
            return false;
        }
        if (this.getTotalSteps() != other.getTotalSteps()) {
            return false;
        }
        List<Scenario> this$scenarios = this.getScenarios();
        List<Scenario> other$scenarios = other.getScenarios();
        return !(this$scenarios == null ? other$scenarios != null : !((Object)this$scenarios).equals(other$scenarios));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Feature;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPassedScenarios();
        result = result * 59 + this.getFailedScenarios();
        result = result * 59 + this.getSkippedScenarios();
        result = result * 59 + this.getTotalScenarios();
        result = result * 59 + this.getPassedSteps();
        result = result * 59 + this.getFailedSteps();
        result = result * 59 + this.getSkippedSteps();
        result = result * 59 + this.getTotalSteps();
        List<Scenario> $scenarios = this.getScenarios();
        result = result * 59 + ($scenarios == null ? 43 : ((Object)$scenarios).hashCode());
        return result;
    }

    private static final class FeatureBuilderImpl
    extends FeatureBuilder<Feature, FeatureBuilderImpl> {
        private FeatureBuilderImpl() {
        }

        @Override
        protected FeatureBuilderImpl self() {
            return this;
        }

        @Override
        public Feature build() {
            return new Feature(this);
        }
    }

    public static abstract class FeatureBuilder<C extends Feature, B extends FeatureBuilder<C, B>>
    extends NonExecutable.NonExecutableBuilder<C, B> {
        private boolean scenarios$set;
        private List<Scenario> scenarios$value;
        private boolean passedScenarios$set;
        private int passedScenarios$value;
        private boolean failedScenarios$set;
        private int failedScenarios$value;
        private boolean skippedScenarios$set;
        private int skippedScenarios$value;
        private boolean totalScenarios$set;
        private int totalScenarios$value;
        private boolean passedSteps$set;
        private int passedSteps$value;
        private boolean failedSteps$set;
        private int failedSteps$value;
        private boolean skippedSteps$set;
        private int skippedSteps$value;
        private boolean totalSteps$set;
        private int totalSteps$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B scenarios(List<Scenario> scenarios) {
            this.scenarios$value = scenarios;
            this.scenarios$set = true;
            return (B)this.self();
        }

        public B passedScenarios(int passedScenarios) {
            this.passedScenarios$value = passedScenarios;
            this.passedScenarios$set = true;
            return (B)this.self();
        }

        public B failedScenarios(int failedScenarios) {
            this.failedScenarios$value = failedScenarios;
            this.failedScenarios$set = true;
            return (B)this.self();
        }

        public B skippedScenarios(int skippedScenarios) {
            this.skippedScenarios$value = skippedScenarios;
            this.skippedScenarios$set = true;
            return (B)this.self();
        }

        public B totalScenarios(int totalScenarios) {
            this.totalScenarios$value = totalScenarios;
            this.totalScenarios$set = true;
            return (B)this.self();
        }

        public B passedSteps(int passedSteps) {
            this.passedSteps$value = passedSteps;
            this.passedSteps$set = true;
            return (B)this.self();
        }

        public B failedSteps(int failedSteps) {
            this.failedSteps$value = failedSteps;
            this.failedSteps$set = true;
            return (B)this.self();
        }

        public B skippedSteps(int skippedSteps) {
            this.skippedSteps$value = skippedSteps;
            this.skippedSteps$set = true;
            return (B)this.self();
        }

        public B totalSteps(int totalSteps) {
            this.totalSteps$value = totalSteps;
            this.totalSteps$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Feature.FeatureBuilder(super=" + super.toString() + ", scenarios$value=" + this.scenarios$value + ", passedScenarios$value=" + this.passedScenarios$value + ", failedScenarios$value=" + this.failedScenarios$value + ", skippedScenarios$value=" + this.skippedScenarios$value + ", totalScenarios$value=" + this.totalScenarios$value + ", passedSteps$value=" + this.passedSteps$value + ", failedSteps$value=" + this.failedSteps$value + ", skippedSteps$value=" + this.skippedSteps$value + ", totalSteps$value=" + this.totalSteps$value + ")";
        }
    }
}

