/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.attributes;

import java.util.List;
import java.util.function.Consumer;
import tech.grasshopper.pdf.data.AttributeData;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.pojo.cucumber.Author;
import tech.grasshopper.pdf.section.attributes.AttributeSection;

public class AuthorSection
extends AttributeSection {
    @Override
    public DisplayData createDisplayData(int fromIndex, int toIndex) {
        List<Author> pageAuthors = ((AttributeData.AuthorData)this.attributeData).getAuthors().subList(fromIndex, toIndex);
        return AttributeData.AuthorData.builder().authors(pageAuthors).build();
    }

    @Override
    public int maxDataCountPerPage() {
        return this.reportConfig.getAuthorConfig().dataCount();
    }

    @Override
    public String attributeType() {
        return "AUTHOR";
    }

    @Override
    public Consumer<Destination> attributeDestinationConsumer() {
        return this.destinations::addAuthorDestination;
    }

    protected AuthorSection(AuthorSectionBuilder<?, ?> b) {
        super((AttributeSection.AttributeSectionBuilder<?, ?>)b);
    }

    public static AuthorSectionBuilder<?, ?> builder() {
        return new AuthorSectionBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorSection)) {
            return false;
        }
        AuthorSection other = (AuthorSection)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AuthorSection;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class AuthorSectionBuilderImpl
    extends AuthorSectionBuilder<AuthorSection, AuthorSectionBuilderImpl> {
        private AuthorSectionBuilderImpl() {
        }

        @Override
        protected AuthorSectionBuilderImpl self() {
            return this;
        }

        @Override
        public AuthorSection build() {
            return new AuthorSection(this);
        }
    }

    public static abstract class AuthorSectionBuilder<C extends AuthorSection, B extends AuthorSectionBuilder<C, B>>
    extends AttributeSection.AttributeSectionBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AuthorSection.AuthorSectionBuilder(super=" + super.toString() + ")";
        }
    }
}

