/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.attributes;

import java.util.List;
import java.util.function.Consumer;
import tech.grasshopper.pdf.data.AttributeData;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.pojo.cucumber.Tag;
import tech.grasshopper.pdf.section.attributes.AttributeSection;

public class TagSection
extends AttributeSection {
    @Override
    public DisplayData createDisplayData(int fromIndex, int toIndex) {
        List<Tag> pageTags = ((AttributeData.TagData)this.attributeData).getTags().subList(fromIndex, toIndex);
        return AttributeData.TagData.builder().tags(pageTags).build();
    }

    @Override
    public int maxDataCountPerPage() {
        return this.reportConfig.getTagConfig().dataCount();
    }

    @Override
    public String attributeType() {
        return "TAG";
    }

    @Override
    public Consumer<Destination> attributeDestinationConsumer() {
        return this.destinations::addTagDestination;
    }

    protected TagSection(TagSectionBuilder<?, ?> b) {
        super((AttributeSection.AttributeSectionBuilder<?, ?>)b);
    }

    public static TagSectionBuilder<?, ?> builder() {
        return new TagSectionBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagSection)) {
            return false;
        }
        TagSection other = (TagSection)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TagSection;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class TagSectionBuilderImpl
    extends TagSectionBuilder<TagSection, TagSectionBuilderImpl> {
        private TagSectionBuilderImpl() {
        }

        @Override
        protected TagSectionBuilderImpl self() {
            return this;
        }

        @Override
        public TagSection build() {
            return new TagSection(this);
        }
    }

    public static abstract class TagSectionBuilder<C extends TagSection, B extends TagSectionBuilder<C, B>>
    extends AttributeSection.AttributeSectionBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TagSection.TagSectionBuilder(super=" + super.toString() + ")";
        }
    }
}

