/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import tech.grasshopper.pdf.data.ExecutableData;

public class MediaCleanup {
    private ExecutableData executableData;
    private MediaCleanupOption mediaCleanupOption;
    private static final Logger logger = Logger.getLogger(MediaCleanup.class.getName());

    public void deleteMedia() {
        if (this.mediaCleanupOption == null || this.mediaCleanupOption.getCleanUpType() == CleanupType.NONE) {
            return;
        }
        List<String> medias = this.executableData.getExecutables().stream().flatMap(e -> e.getMedia().stream()).collect(Collectors.toList());
        medias.forEach(m -> {
            try {
                if (this.checkMediaForDeletion((String)m)) {
                    Files.deleteIfExists(Paths.get(m, new String[0]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.WARNING, "Unable to delete media at location " + m);
            }
        });
    }

    private boolean checkMediaForDeletion(String mediaPath) {
        if (this.mediaCleanupOption.getCleanUpType() == CleanupType.NONE) {
            return false;
        }
        String fileNameWithExt = Paths.get(mediaPath, new String[0]).getFileName().toString();
        int extDotIndex = fileNameWithExt.lastIndexOf(46);
        if (extDotIndex < 1) {
            logger.log(Level.WARNING, "Check media name at location " + mediaPath);
            return false;
        }
        if (this.mediaCleanupOption.getCleanUpType() == CleanupType.ALL) {
            return true;
        }
        String fileName = fileNameWithExt.substring(0, extDotIndex);
        return Pattern.matches(this.mediaCleanupOption.getPattern(), fileName);
    }

    MediaCleanup(ExecutableData executableData, MediaCleanupOption mediaCleanupOption) {
        this.executableData = executableData;
        this.mediaCleanupOption = mediaCleanupOption;
    }

    public static MediaCleanupBuilder builder() {
        return new MediaCleanupBuilder();
    }

    public ExecutableData getExecutableData() {
        return this.executableData;
    }

    public MediaCleanupOption getMediaCleanupOption() {
        return this.mediaCleanupOption;
    }

    public void setExecutableData(ExecutableData executableData) {
        this.executableData = executableData;
    }

    public void setMediaCleanupOption(MediaCleanupOption mediaCleanupOption) {
        this.mediaCleanupOption = mediaCleanupOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaCleanup)) {
            return false;
        }
        MediaCleanup other = (MediaCleanup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutableData this$executableData = this.getExecutableData();
        ExecutableData other$executableData = other.getExecutableData();
        if (this$executableData == null ? other$executableData != null : !this$executableData.equals(other$executableData)) {
            return false;
        }
        MediaCleanupOption this$mediaCleanupOption = this.getMediaCleanupOption();
        MediaCleanupOption other$mediaCleanupOption = other.getMediaCleanupOption();
        return !(this$mediaCleanupOption == null ? other$mediaCleanupOption != null : !this$mediaCleanupOption.equals(other$mediaCleanupOption));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MediaCleanup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutableData $executableData = this.getExecutableData();
        result = result * 59 + ($executableData == null ? 43 : $executableData.hashCode());
        MediaCleanupOption $mediaCleanupOption = this.getMediaCleanupOption();
        result = result * 59 + ($mediaCleanupOption == null ? 43 : $mediaCleanupOption.hashCode());
        return result;
    }

    public String toString() {
        return "MediaCleanup(executableData=" + this.getExecutableData() + ", mediaCleanupOption=" + this.getMediaCleanupOption() + ")";
    }

    public static class MediaCleanupBuilder {
        private ExecutableData executableData;
        private MediaCleanupOption mediaCleanupOption;

        MediaCleanupBuilder() {
        }

        public MediaCleanupBuilder executableData(ExecutableData executableData) {
            this.executableData = executableData;
            return this;
        }

        public MediaCleanupBuilder mediaCleanupOption(MediaCleanupOption mediaCleanupOption) {
            this.mediaCleanupOption = mediaCleanupOption;
            return this;
        }

        public MediaCleanup build() {
            return new MediaCleanup(this.executableData, this.mediaCleanupOption);
        }

        public String toString() {
            return "MediaCleanup.MediaCleanupBuilder(executableData=" + this.executableData + ", mediaCleanupOption=" + this.mediaCleanupOption + ")";
        }
    }

    public static class MediaCleanupOption {
        private CleanupType cleanUpType;
        private String pattern;

        private static CleanupType $default$cleanUpType() {
            return CleanupType.NONE;
        }

        private static String $default$pattern() {
            return "";
        }

        MediaCleanupOption(CleanupType cleanUpType, String pattern) {
            this.cleanUpType = cleanUpType;
            this.pattern = pattern;
        }

        public static MediaCleanupOptionBuilder builder() {
            return new MediaCleanupOptionBuilder();
        }

        public CleanupType getCleanUpType() {
            return this.cleanUpType;
        }

        public String getPattern() {
            return this.pattern;
        }

        public static class MediaCleanupOptionBuilder {
            private boolean cleanUpType$set;
            private CleanupType cleanUpType$value;
            private boolean pattern$set;
            private String pattern$value;

            MediaCleanupOptionBuilder() {
            }

            public MediaCleanupOptionBuilder cleanUpType(CleanupType cleanUpType) {
                this.cleanUpType$value = cleanUpType;
                this.cleanUpType$set = true;
                return this;
            }

            public MediaCleanupOptionBuilder pattern(String pattern) {
                this.pattern$value = pattern;
                this.pattern$set = true;
                return this;
            }

            public MediaCleanupOption build() {
                CleanupType cleanUpType$value = this.cleanUpType$value;
                if (!this.cleanUpType$set) {
                    cleanUpType$value = MediaCleanupOption.$default$cleanUpType();
                }
                String pattern$value = this.pattern$value;
                if (!this.pattern$set) {
                    pattern$value = MediaCleanupOption.$default$pattern();
                }
                return new MediaCleanupOption(cleanUpType$value, pattern$value);
            }

            public String toString() {
                return "MediaCleanup.MediaCleanupOption.MediaCleanupOptionBuilder(cleanUpType$value=" + this.cleanUpType$value + ", pattern$value=" + this.pattern$value + ")";
            }
        }
    }

    public static enum CleanupType {
        ALL,
        NONE,
        PATTERN;

    }
}

