/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.feature;

import java.awt.Color;
import java.util.stream.IntStream;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import tech.grasshopper.pdf.chart.ReportStackedBarChart;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.image.ImageCreator;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.structure.Display;

public class FeatureStackedBarChart
extends Display {
    private int fromXData;
    private int toXData;

    @Override
    public void display() {
        this.createBarChart();
    }

    private void createBarChart() {
        int[] passed = new int[this.toXData - this.fromXData];
        int[] failed = new int[this.toXData - this.fromXData];
        int[] skipped = new int[this.toXData - this.fromXData];
        int[] xData = new int[this.toXData - this.fromXData];
        xData = IntStream.rangeClosed(this.fromXData + 1, this.toXData).toArray();
        ReportStackedBarChart chart = new ReportStackedBarChart(600, 200);
        chart.setYAxisTitle("# of Scenarios");
        this.updateBarChartStyler((CategoryStyler)chart.getStyler());
        this.createStackedBarChartData(passed, failed, skipped);
        chart.updateData(xData, passed, failed, skipped);
        ImageCreator.builder().document(this.document).chart((Chart<?, ?>)chart).content(this.content).build().generateAndDisplayChartImage(120.0f, 350.0f);
    }

    private void updateBarChartStyler(CategoryStyler styler) {
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
        styler.setAvailableSpaceFill(0.4 * (double)(this.toXData - this.fromXData) / 10.0);
    }

    private void createStackedBarChartData(int[] passed, int[] failed, int[] skipped) {
        FeatureData featureData = (FeatureData)this.displayData;
        for (int i = 0; i < featureData.getFeatures().size(); ++i) {
            Feature feature = featureData.getFeatures().get(i);
            passed[i] = feature.getPassedScenarios();
            failed[i] = feature.getFailedScenarios();
            skipped[i] = feature.getSkippedScenarios();
        }
    }

    protected FeatureStackedBarChart(FeatureStackedBarChartBuilder<?, ?> b) {
        super(b);
        this.fromXData = b.fromXData;
        this.toXData = b.toXData;
    }

    public static FeatureStackedBarChartBuilder<?, ?> builder() {
        return new FeatureStackedBarChartBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureStackedBarChart)) {
            return false;
        }
        FeatureStackedBarChart other = (FeatureStackedBarChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.fromXData != other.fromXData) {
            return false;
        }
        return this.toXData == other.toXData;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeatureStackedBarChart;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.fromXData;
        result = result * 59 + this.toXData;
        return result;
    }

    private static final class FeatureStackedBarChartBuilderImpl
    extends FeatureStackedBarChartBuilder<FeatureStackedBarChart, FeatureStackedBarChartBuilderImpl> {
        private FeatureStackedBarChartBuilderImpl() {
        }

        @Override
        protected FeatureStackedBarChartBuilderImpl self() {
            return this;
        }

        @Override
        public FeatureStackedBarChart build() {
            return new FeatureStackedBarChart(this);
        }
    }

    public static abstract class FeatureStackedBarChartBuilder<C extends FeatureStackedBarChart, B extends FeatureStackedBarChartBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private int fromXData;
        private int toXData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B fromXData(int fromXData) {
            this.fromXData = fromXData;
            return (B)this.self();
        }

        public B toXData(int toXData) {
            this.toXData = toXData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FeatureStackedBarChart.FeatureStackedBarChartBuilder(super=" + super.toString() + ", fromXData=" + this.fromXData + ", toXData=" + this.toXData + ")";
        }
    }
}

