/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.scenario;

import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.section.scenario.ScenarioStackedBarChart;
import tech.grasshopper.pdf.section.scenario.ScenarioStepDetails;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.paginate.PaginatedDisplay;

public class ScenarioDisplay
extends PaginatedDisplay
implements DestinationAware {
    private static final String SECTION_TITLE = "SCENARIOS SUMMARY";
    private List<Integer> featureNameRowSpans;

    @Override
    public void display() {
        this.page = PageCreator.builder().document(this.document).build().createLandscapePageWithHeaderAndNumberAndAddToDocument(SECTION_TITLE);
        this.content = new PDPageContentStream(this.document, this.page, PDPageContentStream.AppendMode.APPEND, true);
        this.createStackedBarChart();
        this.createTable();
        this.createDestination();
        this.content.close();
    }

    private void createStackedBarChart() {
        ((ScenarioStackedBarChart)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)ScenarioStackedBarChart.builder().document(this.document)).content(this.content)).displayData(this.displayData)).reportConfig(this.reportConfig)).fromXData(this.paginationData.getItemFromIndex())).toXData(this.paginationData.getItemToIndex())).build()).display();
    }

    private void createTable() {
        ((ScenarioStepDetails)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)ScenarioStepDetails.builder().displayData(this.displayData)).content(this.content)).reportConfig(this.reportConfig)).document(this.document)).paginationData(this.paginationData)).featureNameRowSpans(this.featureNameRowSpans)).build()).display();
    }

    @Override
    public void createDestination() {
        Destination destination = Destination.builder().name("SCENARIOS - " + (this.paginationData.getItemFromIndex() + 1) + " to " + this.paginationData.getItemToIndex()).yCoord((int)this.page.getMediaBox().getHeight()).page(this.page).build();
        this.destinations.addScenarioDestination(destination);
    }

    protected ScenarioDisplay(ScenarioDisplayBuilder<?, ?> b) {
        super((PaginatedDisplay.PaginatedDisplayBuilder<?, ?>)b);
        this.featureNameRowSpans = b.featureNameRowSpans;
    }

    public static ScenarioDisplayBuilder<?, ?> builder() {
        return new ScenarioDisplayBuilderImpl();
    }

    private static final class ScenarioDisplayBuilderImpl
    extends ScenarioDisplayBuilder<ScenarioDisplay, ScenarioDisplayBuilderImpl> {
        private ScenarioDisplayBuilderImpl() {
        }

        @Override
        protected ScenarioDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public ScenarioDisplay build() {
            return new ScenarioDisplay(this);
        }
    }

    public static abstract class ScenarioDisplayBuilder<C extends ScenarioDisplay, B extends ScenarioDisplayBuilder<C, B>>
    extends PaginatedDisplay.PaginatedDisplayBuilder<C, B> {
        private List<Integer> featureNameRowSpans;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B featureNameRowSpans(List<Integer> featureNameRowSpans) {
            this.featureNameRowSpans = featureNameRowSpans;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScenarioDisplay.ScenarioDisplayBuilder(super=" + super.toString() + ", featureNameRowSpans=" + this.featureNameRowSpans + ")";
        }
    }
}

