/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.scenario;

import java.util.List;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.section.scenario.ScenarioDisplay;
import tech.grasshopper.pdf.section.scenario.ScenarioStepDetails;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.structure.paginate.PaginationData;
import tech.grasshopper.pdf.structure.paginate.ScenarioPaginator;
import tech.grasshopper.pdf.util.TextUtil;

public class ScenarioSection
extends PaginatedSection {
    protected ScenarioData scenarioData;
    protected List<Integer> featureNameRowSpans;

    @Override
    public void createSection() {
        this.scenarioData = (ScenarioData)this.displayData;
        if (this.scenarioData.getScenarios().isEmpty()) {
            return;
        }
        ScenarioPaginator paginator = ScenarioPaginator.builder().data(this.scenarioData).maxScenariosPerPage(this.maxScenariosPerPage()).tableSpace(this.tableSpace()).headerRowHeight(this.headerRowHeight()).textUtilFeature(this.featureNameTextUtil()).textUtilScenario(this.scenarioNameTextUtil()).featureNameTextOptimizer(this.featureNameTextOptimizer()).scenarioNameTextOptimizer(this.scenarioNameTextOptimizer()).section(this).build();
        paginator.paginate();
    }

    @Override
    public void generateDisplay(int fromIndex, int toIndex) {
        ((ScenarioDisplay)((ScenarioDisplay.ScenarioDisplayBuilder)((ScenarioDisplay.ScenarioDisplayBuilder)((ScenarioDisplay.ScenarioDisplayBuilder)((ScenarioDisplay.ScenarioDisplayBuilder)((ScenarioDisplay.ScenarioDisplayBuilder)((ScenarioDisplay.ScenarioDisplayBuilder)ScenarioDisplay.builder().displayData(this.createDisplayData(fromIndex, toIndex))).document(this.document)).reportConfig(this.reportConfig)).destinations(this.destinations)).paginationData(PaginationData.builder().itemsPerPage(this.maxScenariosPerPage()).itemFromIndex(fromIndex).itemToIndex(toIndex).build())).featureNameRowSpans(this.featureNameRowSpans)).build()).display();
    }

    @Override
    public DisplayData createDisplayData(int fromIndex, int toIndex) {
        List<Scenario> pageScenarios = this.scenarioData.getScenarios().subList(fromIndex, toIndex);
        return ScenarioData.builder().scenarios(pageScenarios).build();
    }

    protected int maxScenariosPerPage() {
        return this.reportConfig.getScenarioConfig().scenarioCount();
    }

    protected float tableSpace() {
        return 290.0f;
    }

    protected float headerRowHeight() {
        return ScenarioStepDetails.headerRowTextUtil.tableRowHeight();
    }

    protected TextUtil featureNameTextUtil() {
        return ScenarioStepDetails.featureNameTextUtil;
    }

    protected TextUtil scenarioNameTextUtil() {
        return ScenarioStepDetails.scenarioNameTextUtil;
    }

    protected TextLengthOptimizer featureNameTextOptimizer() {
        return ScenarioStepDetails.featureNameTextOptimizer;
    }

    protected TextLengthOptimizer scenarioNameTextOptimizer() {
        return ScenarioStepDetails.scenarioNameTextOptimizer;
    }

    protected ScenarioSection(ScenarioSectionBuilder<?, ?> b) {
        super((PaginatedSection.PaginatedSectionBuilder<?, ?>)b);
        this.scenarioData = b.scenarioData;
        this.featureNameRowSpans = b.featureNameRowSpans;
    }

    public static ScenarioSectionBuilder<?, ?> builder() {
        return new ScenarioSectionBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScenarioSection)) {
            return false;
        }
        ScenarioSection other = (ScenarioSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScenarioData this$scenarioData = this.scenarioData;
        ScenarioData other$scenarioData = other.scenarioData;
        if (this$scenarioData == null ? other$scenarioData != null : !this$scenarioData.equals(other$scenarioData)) {
            return false;
        }
        List<Integer> this$featureNameRowSpans = this.featureNameRowSpans;
        List<Integer> other$featureNameRowSpans = other.featureNameRowSpans;
        return !(this$featureNameRowSpans == null ? other$featureNameRowSpans != null : !((Object)this$featureNameRowSpans).equals(other$featureNameRowSpans));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScenarioSection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScenarioData $scenarioData = this.scenarioData;
        result = result * 59 + ($scenarioData == null ? 43 : $scenarioData.hashCode());
        List<Integer> $featureNameRowSpans = this.featureNameRowSpans;
        result = result * 59 + ($featureNameRowSpans == null ? 43 : ((Object)$featureNameRowSpans).hashCode());
        return result;
    }

    public void setFeatureNameRowSpans(List<Integer> featureNameRowSpans) {
        this.featureNameRowSpans = featureNameRowSpans;
    }

    private static final class ScenarioSectionBuilderImpl
    extends ScenarioSectionBuilder<ScenarioSection, ScenarioSectionBuilderImpl> {
        private ScenarioSectionBuilderImpl() {
        }

        @Override
        protected ScenarioSectionBuilderImpl self() {
            return this;
        }

        @Override
        public ScenarioSection build() {
            return new ScenarioSection(this);
        }
    }

    public static abstract class ScenarioSectionBuilder<C extends ScenarioSection, B extends ScenarioSectionBuilder<C, B>>
    extends PaginatedSection.PaginatedSectionBuilder<C, B> {
        private ScenarioData scenarioData;
        private List<Integer> featureNameRowSpans;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B scenarioData(ScenarioData scenarioData) {
            this.scenarioData = scenarioData;
            return (B)this.self();
        }

        public B featureNameRowSpans(List<Integer> featureNameRowSpans) {
            this.featureNameRowSpans = featureNameRowSpans;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScenarioSection.ScenarioSectionBuilder(super=" + super.toString() + ", scenarioData=" + this.scenarioData + ", featureNameRowSpans=" + this.featureNameRowSpans + ")";
        }
    }
}

