/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.util;

import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.util.PdfUtil;

public class TextUtil {
    private PDFont font;
    private int fontSize;
    private String text;
    private float width;
    private float lineSpacing;
    private float padding;

    public float tableRowHeight() {
        float textHeight = PdfUtil.getFontHeight((PDFont)this.font, (int)this.fontSize);
        int size = PdfUtil.getOptimalTextBreakLines((String)this.text, (PDFont)this.font, (int)this.fontSize, (float)(this.width - 2.0f * this.padding)).size();
        float heightOfTextLines = (float)size * textHeight;
        float heightOfLineSpacing = (float)(size - 1) * textHeight * this.lineSpacing;
        return heightOfTextLines + heightOfLineSpacing + 2.0f * this.padding;
    }

    private static float $default$lineSpacing() {
        return 1.0f;
    }

    private static float $default$padding() {
        return 0.0f;
    }

    TextUtil(PDFont font, int fontSize, String text, float width, float lineSpacing, float padding) {
        this.font = font;
        this.fontSize = fontSize;
        this.text = text;
        this.width = width;
        this.lineSpacing = lineSpacing;
        this.padding = padding;
    }

    public static TextUtilBuilder builder() {
        return new TextUtilBuilder();
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public static class TextUtilBuilder {
        private PDFont font;
        private int fontSize;
        private String text;
        private float width;
        private boolean lineSpacing$set;
        private float lineSpacing$value;
        private boolean padding$set;
        private float padding$value;

        TextUtilBuilder() {
        }

        public TextUtilBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public TextUtilBuilder fontSize(int fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public TextUtilBuilder text(String text) {
            this.text = text;
            return this;
        }

        public TextUtilBuilder width(float width) {
            this.width = width;
            return this;
        }

        public TextUtilBuilder lineSpacing(float lineSpacing) {
            this.lineSpacing$value = lineSpacing;
            this.lineSpacing$set = true;
            return this;
        }

        public TextUtilBuilder padding(float padding) {
            this.padding$value = padding;
            this.padding$set = true;
            return this;
        }

        public TextUtil build() {
            float lineSpacing$value = this.lineSpacing$value;
            if (!this.lineSpacing$set) {
                lineSpacing$value = TextUtil.$default$lineSpacing();
            }
            float padding$value = this.padding$value;
            if (!this.padding$set) {
                padding$value = TextUtil.$default$padding();
            }
            return new TextUtil(this.font, this.fontSize, this.text, this.width, lineSpacing$value, padding$value);
        }

        public String toString() {
            return "TextUtil.TextUtilBuilder(font=" + this.font + ", fontSize=" + this.fontSize + ", text=" + this.text + ", width=" + this.width + ", lineSpacing$value=" + this.lineSpacing$value + ", padding$value=" + this.padding$value + ")";
        }
    }
}

